import os
import json

import config


def get_bot_config(bot_name):
    folder = os.path.join(config.RESOURCE_DIR, 'bot_configs')
    path = os.path.join(folder, f'{bot_name}.json')
    return load_json(path)


def get_bot_names():
    folder = os.path.join(config.RESOURCE_DIR, 'bot_configs')
    out = [name.split('.json')[0] for name in os.listdir(folder)]
    return out


def load_json(path):
    with open(path, 'r') as f:
        return json.load(f)


def get_bot_picture_html(bot_config):
    model_html = f"""
    <div class="inline-flex flex-col" style="line-height: 1.5;">
        <div class="flex">
            <div
    \t\t\tstyle="display:DISPLAY_1; margin-left: auto; margin-right: auto; width: 92px; height:92px; border-radius: 50%; background-size: cover; background-image: url(&#39;{bot_config['imageUrl']}&#39;)">
            </div>
        </div>
        <div style="text-align: center; font-size: 16px; font-weight: 800">{bot_config['name']}</div>
    </div>
    """
    return model_html
