import gradio as gr
import config
from modules import utils

from modules.models import GuanacoModel, ChaiBot


def render_section_separator(title):
    with gr.Row():
        gr.Markdown(f"## {title}")


def render_model_selector():
    model_ids = list(config.MODELS.keys())
    model_tag = gr.Dropdown(
        model_ids,
        value=model_ids[0],
        allow_custom_values=False,
        label="Model ID",
        info="Select a model to chat with.",
        interactive=True
    )
    return model_tag


def render_bot_profile(bot_config):
    with gr.Row():
        with gr.Column():
            bot_profile = _render_bot_profile_picture(bot_config)
        with gr.Column():
            bot_selector = _render_bot_selector()
    return bot_profile, bot_selector


def _render_bot_profile_picture(bot_config):
    bot_profile = gr.HTML(utils.get_bot_picture_html(bot_config))
    return bot_profile


def _render_bot_selector():
    bot_names = utils.get_bot_names()
    dropdown = gr.Dropdown(
        bot_names,
        value=config.DEFAULT_BOT_NAME,
        allow_custom_values=False,
        label="Bot Name",
        info="Select a bot to chat with.",
    )
    return dropdown


def render_bot_config(bot_config):
    with gr.Accordion("Bot configuration:", open=False):
        bot_config_text = gr.Markdown(
            f"# Memory\n{bot_config.get('memory', '')}\n# Prompt\n{bot_config.get('prompt', '')}")
    return bot_config_text


def render_chat_buttons():
    with gr.Row():
        msg = gr.Textbox(placeholder="Enter a message!")
        send = gr.Button("Send")
        regenerate = gr.Button("Regenerate")
    with gr.Row():
        clear = gr.Button("New conversation")
    return msg, send, regenerate, clear


def get_convo_state(bot_config):
    bot = ChaiBot(bot_config)
    return gr.State(bot)


def get_model_state(model_config):
    model = GuanacoModel(model_config)
    return gr.State(model)
