##THIS IS FOR SUPER-RESOLUTION\

import gradio as gr
from PIL import Image
import tensorflow as tf
import tensorflow_hub as hub
import numpy as np
import requests
import cv2
from tensorflow.python.keras.layers import Add, Conv2D, Input, Lambda
from tensorflow.python.keras.models import Model


super_resolution='./weights.h5'


pre_mean = np.array([0.4488, 0.4371, 0.4040]) * 255


#HELPER FUN
def normalize(x, rgb_mean=pre_mean):
    return (x - rgb_mean) / 127.5

#HELPER FUN
def pixel_shuffle(scale):
    return lambda x: tf.nn.depth_to_space(x, scale)

#HELPER FUN
def denormalize(x, rgb_mean=pre_mean):
    return x * 127.5 + rgb_mean


#MAIN FUN
def res_block(x_in, filters, scaling):
    x = Conv2D(filters, 3, padding='same', activation='relu')(x_in)
    x = Conv2D(filters, 3, padding='same')(x)
    x =tf.keras.layers.LeakyReLU(alpha = 0.01)(x)
    x = tf.keras.layers.BatchNormalization()(x)
    if scaling:
        x = Lambda(lambda t: t * scaling)(x)
    x = Add()([x_in, x])
    return x



#HELPER FUN
def upsample(x, scale, num_filters):
    def upsample_1(x, factor, **kwargs):
        x = Conv2D(num_filters * (factor ** 2), 3, padding='same', **kwargs)(x)
        return Lambda(pixel_shuffle(scale=factor))(x)

    if scale == 2:
        x = upsample_1(x, 2, name='conv2d_1_scale_2')
    elif scale == 3:
        x = upsample_1(x, 3, name='conv2d_1_scale_3')
    elif scale == 4:
        x = upsample_1(x, 2, name='conv2d_1_scale_2')
        x = upsample_1(x, 2, name='conv2d_2_scale_2')

    return x

#MAIN FUN
def super_res(scale, num_filters=64, num_res_blocks=8, res_block_scaling=None):
    x_in = Input(shape=(None, None, 3))
    x = Lambda(normalize)(x_in)
    x = b = Conv2D(num_filters, 3, padding='same')(x)
    
    for i in range(num_res_blocks):
        b = res_block(b, num_filters, res_block_scaling)
    b = Conv2D(num_filters, 3, padding='same')(b)
    x = Add()([x, b])

    x = upsample(x, scale, num_filters)
    x = Conv2D(3, 3, padding='same')(x)

    x = Lambda(denormalize)(x)
    return Model(x_in, x, name="super_res")




def load_image(path):
    return np.array(path)

    
    
    
def resolve(model, lr_batch):
    lr_batch = tf.cast(lr_batch, tf.float32)
    sr_batch = model(lr_batch)
    sr_batch = tf.clip_by_value(sr_batch, 0, 255)
    sr_batch = tf.round(sr_batch)
    sr_batch = tf.cast(sr_batch, tf.uint8)
    return sr_batch



def resolve_single(model, lr):
    return resolve(model, tf.expand_dims(lr, axis=0))[0]



model=super_res(scale=4, num_res_blocks=16)


model.load_weights(super_resolution)


def predict_image(image):
    lr=load_image(image)
    sr = resolve_single(model, lr)
    numpy_array = sr.numpy()
    ima = Image.fromarray(numpy_array)
    return ima



image=gr.inputs.Image()

irface=gr.Interface(fn=predict_image, inputs=image, outputs=image,interpretation='default')

irface.launch() 