import gradio as gr
import requests
import tensorflow as tf
import tensorflow_hub as hub

path = '20220804-16551659632113-all-images-Adam.h5'
model = tf.keras.models.load_model(path,custom_objects={"KerasLayer":hub.KerasLayer})

labels = ['affenpinscher', 'afghan_hound', 'african_hunting_dog', 'airedale',
    'american_staffordshire_terrier', 'appenzeller',
    'australian_terrier', 'basenji', 'basset', 'beagle',
    'bedlington_terrier', 'bernese_mountain_dog',
    'black-and-tan_coonhound', 'blenheim_spaniel', 'bloodhound',
    'bluetick', 'border_collie', 'border_terrier', 'borzoi',
    'boston_bull', 'bouvier_des_flandres', 'boxer',
    'brabancon_griffon', 'briard', 'brittany_spaniel', 'bull_mastiff',
    'cairn', 'cardigan', 'chesapeake_bay_retriever', 'chihuahua',
    'chow', 'clumber', 'cocker_spaniel', 'collie',
    'curly-coated_retriever', 'dandie_dinmont', 'dhole', 'dingo',
    'doberman', 'english_foxhound', 'english_setter',
    'english_springer', 'entlebucher', 'eskimo_dog',
    'flat-coated_retriever', 'french_bulldog', 'german_shepherd',
    'german_short-haired_pointer', 'giant_schnauzer',
    'golden_retriever', 'gordon_setter', 'great_dane',
    'great_pyrenees', 'greater_swiss_mountain_dog', 'groenendael',
    'ibizan_hound', 'irish_setter', 'irish_terrier',
    'irish_water_spaniel', 'irish_wolfhound', 'italian_greyhound',
    'japanese_spaniel', 'keeshond', 'kelpie', 'kerry_blue_terrier',
    'komondor', 'kuvasz', 'labrador_retriever', 'lakeland_terrier',
    'leonberg', 'lhasa', 'malamute', 'malinois', 'maltese_dog',
    'mexican_hairless', 'miniature_pinscher', 'miniature_poodle',
    'miniature_schnauzer', 'newfoundland', 'norfolk_terrier',
    'norwegian_elkhound', 'norwich_terrier', 'old_english_sheepdog',
    'otterhound', 'papillon', 'pekinese', 'pembroke', 'pomeranian',
    'pug', 'redbone', 'rhodesian_ridgeback', 'rottweiler',
    'saint_bernard', 'saluki', 'samoyed', 'schipperke',
    'scotch_terrier', 'scottish_deerhound', 'sealyham_terrier',
    'shetland_sheepdog', 'shih-tzu', 'siberian_husky', 'silky_terrier',
    'soft-coated_wheaten_terrier', 'staffordshire_bullterrier',
    'standard_poodle', 'standard_schnauzer', 'sussex_spaniel',
    'tibetan_mastiff', 'tibetan_terrier', 'toy_poodle', 'toy_terrier',
    'vizsla', 'walker_hound', 'weimaraner', 'welsh_springer_spaniel',
    'west_highland_white_terrier', 'whippet',
    'wire-haired_fox_terrier', 'yorkshire_terrier']

# load the model
def predict_breed(image):

    
    # reshape the input
    image = image.reshape((-1, 224, 224, 3))

    image = tf.image.convert_image_dtype(image, dtype=tf.float32)
    
    image = tf.constant(image)

    # prediction = model_1000_images.predict(image).flatten()
    prediction = model.predict(image).flatten()
    
    # return prediction labels
    return {labels[i]: float(prediction[i]) for i in range(120)}

title = "Dog Vision"
description = "A Dog Breed Classifier trained on the MobileNetV2 Deep Learning Model result."

examples = ['German.jpg']

enable_queue=True

gr.Interface(
   fn=predict_breed,
   inputs=gr.inputs.Image(shape=(224, 224)),
   outputs=gr.outputs.Label(num_top_classes=3),
   title=title,
   description=description,
   examples=examples,
   cache_examples=True,
   examples_per_page=2,
   enable_queue=enable_queue).launch()