# flake8: noqa: E402

import sys, os
import logging
import os
import time
import numpy as np  # 假设你使用NumPy来处理音频数据
import shutil  # 用于删除文件夹和文件
from scipy.io import wavfile

logging.getLogger("numba").setLevel(logging.WARNING)
logging.getLogger("markdown_it").setLevel(logging.WARNING)
logging.getLogger("urllib3").setLevel(logging.WARNING)
logging.getLogger("matplotlib").setLevel(logging.WARNING)

logging.basicConfig(
    level=logging.INFO, format="| %(name)s | %(levelname)s | %(message)s"
)

logger = logging.getLogger(__name__)

import torch
import argparse
import commons
import utils
from models import SynthesizerTrn
from text.symbols import symbols
from text import cleaned_text_to_sequence, get_bert
from text.cleaner import clean_text
import gradio as gr
import webbrowser
import numpy as np

net_g = None

if sys.platform == "darwin" and torch.backends.mps.is_available():
    device = "mps"
    os.environ["PYTORCH_ENABLE_MPS_FALLBACK"] = "1"
else:
    device = "cuda"


def get_text(text, language_str, hps):
    norm_text, phone, tone, word2ph = clean_text(text, language_str)
    phone, tone, language = cleaned_text_to_sequence(phone, tone, language_str)

    if hps.data.add_blank:
        phone = commons.intersperse(phone, 0)
        tone = commons.intersperse(tone, 0)
        language = commons.intersperse(language, 0)
        for i in range(len(word2ph)):
            word2ph[i] = word2ph[i] * 2
        word2ph[0] += 1
    bert = get_bert(norm_text, word2ph, language_str, device)
    del word2ph
    assert bert.shape[-1] == len(phone), phone

    if language_str == "ZH":
        bert = bert
        ja_bert = torch.zeros(768, len(phone))
    elif language_str == "JP":
        ja_bert = bert
        bert = torch.zeros(1024, len(phone))
    else:
        bert = torch.zeros(1024, len(phone))
        ja_bert = torch.zeros(768, len(phone))

    assert bert.shape[-1] == len(
        phone
    ), f"Bert seq len {bert.shape[-1]} != {len(phone)}"

    phone = torch.LongTensor(phone)
    tone = torch.LongTensor(tone)
    language = torch.LongTensor(language)
    return bert, ja_bert, phone, tone, language


def infer(text, sdp_ratio, noise_scale, noise_scale_w, length_scale, sid, language):
    global net_g
    bert, ja_bert, phones, tones, lang_ids = get_text(text, language, hps)
    with torch.no_grad():
        x_tst = phones.to(device).unsqueeze(0)
        tones = tones.to(device).unsqueeze(0)
        lang_ids = lang_ids.to(device).unsqueeze(0)
        bert = bert.to(device).unsqueeze(0)
        ja_bert = ja_bert.to(device).unsqueeze(0)
        x_tst_lengths = torch.LongTensor([phones.size(0)]).to(device)
        #print(x_tst.type(), tones.type(), lang_ids.type(), bert.type(), ja_bert.type(), x_tst_lengths.type())
        del phones
        speakers = torch.LongTensor([hps.data.spk2id[sid]]).to(device)
        audio = (
            net_g.infer(
                x_tst,
                x_tst_lengths,
                speakers,
                tones,
                lang_ids,
                bert,
                ja_bert,
                sdp_ratio=sdp_ratio,
                noise_scale=noise_scale,
                noise_scale_w=noise_scale_w,
                length_scale=length_scale,
            )[0][0, 0]
            .data.cpu()
            .float()
            .numpy()
        )
        del x_tst, tones, lang_ids, bert, x_tst_lengths, speakers
        torch.cuda.empty_cache()
        return audio
    
def infer_2(text, sdp_ratio, noise_scale, noise_scale_w, length_scale, sid, language):
    global net_g_2
    bert, ja_bert, phones, tones, lang_ids = get_text(text, language, hps)
    with torch.no_grad():
        x_tst = phones.to(device).unsqueeze(0)
        tones = tones.to(device).unsqueeze(0)
        lang_ids = lang_ids.to(device).unsqueeze(0)
        bert = bert.to(device).unsqueeze(0)
        ja_bert = ja_bert.to(device).unsqueeze(0)
        x_tst_lengths = torch.LongTensor([phones.size(0)]).to(device)
        #print(x_tst.type(), tones.type(), lang_ids.type(), bert.type(), ja_bert.type(), x_tst_lengths.type())
        del phones
        speakers = torch.LongTensor([hps_2.data.spk2id[sid]]).to(device)
        audio = (
            net_g_2.infer(
                x_tst,
                x_tst_lengths,
                speakers,
                tones,
                lang_ids,
                bert,
                ja_bert,
                sdp_ratio=sdp_ratio,
                noise_scale=noise_scale,
                noise_scale_w=noise_scale_w,
                length_scale=length_scale,
            )[0][0, 0]
            .data.cpu()
            .float()
            .numpy()
        )
        del x_tst, tones, lang_ids, bert, x_tst_lengths, speakers
        torch.cuda.empty_cache()
        return audio

__LOG__ = "./generation_logs.txt"
def tts_fn(text, speaker, sdp_ratio, noise_scale, noise_scale_w, length_scale, language,from_model=0):
    # 清空 ./infer_save 文件夹
    if os.path.exists('./infer_save'):
        shutil.rmtree('./infer_save')
    os.makedirs('./infer_save')

    slices = text.split("\n")
    slices = [slice for slice in slices if slice.strip() != ""]
    audio_list = []
    with torch.no_grad():
        with open(__LOG__,"a",encoding="UTF-8") as f:
            for slice in slices:
                assert len(slice) < 150 # 限制输入的文本长度
                if from_model == 0:
                    audio = infer(slice, sdp_ratio=sdp_ratio, noise_scale=noise_scale, noise_scale_w=noise_scale_w, length_scale=length_scale, sid=speaker, language=language)
                else:
                    audio = infer_2(slice, sdp_ratio=sdp_ratio, noise_scale=noise_scale, noise_scale_w=noise_scale_w, length_scale=length_scale, sid=speaker, language=language)
                audio_list.append(audio)
                
                # 创建唯一的文件名
                timestamp = str(int(time.time() * 1000))
                audio_file_path = f'./infer_save/audio_{timestamp}.wav'
                
                # 保存音频数据到.wav文件
                wavfile.write(audio_file_path, hps.data.sampling_rate, audio)
                
                silence = np.zeros(int(hps.data.sampling_rate/2), dtype=np.int16)  # 生成半秒的静音
                audio_list.append(silence)  # 将静音添加到列表中
                
                f.write(f"{slice} | {speaker}\n")
                print(f"{slice} | {speaker}")

    audio_concat = np.concatenate(audio_list)
    return "Success", (hps.data.sampling_rate, audio_concat)
def tts_fn_2(text, speaker, sdp_ratio, noise_scale, noise_scale_w, length_scale, language,from_model=1):
    return  tts_fn(text, speaker, sdp_ratio, noise_scale, noise_scale_w, length_scale, language,from_model)

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument(
        "-m", "--model", default="./logs/natuki/G_72000.pth", help="path of your model"
    )
    parser.add_argument(
        "-c",
        "--config",
        default="./configs/config.json",
        help="path of your config file",
    )
    parser.add_argument(
        "--share", default=False, help="make link public", action="store_true"
    )
    parser.add_argument(
        "-d", "--debug", action="store_true", help="enable DEBUG-LEVEL log"
    )

    args = parser.parse_args()
    if args.debug:
        logger.info("Enable DEBUG-LEVEL log")
        logging.basicConfig(level=logging.DEBUG)
    hps = utils.get_hparams_from_file("./logs/digital/config.json")
    hps_2 = utils.get_hparams_from_file("./logs/fukukitaru/config.json")

    device = (
        "cuda:0"
        if torch.cuda.is_available()
        else (
            "mps"
            if sys.platform == "darwin" and torch.backends.mps.is_available()
            else "cpu"
        )
    )
    net_g = SynthesizerTrn(
        len(symbols),
        hps.data.filter_length // 2 + 1,
        hps.train.segment_size // hps.data.hop_length,
        n_speakers=hps.data.n_speakers,
        **hps.model,
    ).to(device)
    _ = net_g.eval()

    net_g_2 = SynthesizerTrn(
        len(symbols),
        hps.data.filter_length // 2 + 1,
        hps.train.segment_size // hps.data.hop_length,
        n_speakers=hps.data.n_speakers,
        **hps.model,
    ).to(device)

    _ = utils.load_checkpoint("./logs/digital/G_10500.pth", net_g, None, skip_optimizer=True)
    _ = utils.load_checkpoint("./logs/fukukitaru/G_10000.pth", net_g_2, None, skip_optimizer=True)

    speaker_ids = hps.data.spk2id
    speakers = list(speaker_ids.keys())
    speaker_ids_2 = hps_2.data.spk2id
    speakers_2 = list(speaker_ids_2.keys())


    languages = ["ZH", "JP"]
    with gr.Blocks() as app:
        with gr.Tab(label="umamusume"):
            with gr.Row():
                with gr.Column():
                    text = gr.TextArea(
                        label="Text",
                        placeholder="Input Text Here",
                        value="はりきっていこう！",
                    )
                    speaker = gr.Dropdown(
                        choices=speakers, value=speakers[0], label="Speaker"
                    )
                    sdp_ratio = gr.Slider(
                        minimum=0, maximum=1, value=0.2, step=0.1, label="SDP Ratio"
                    )
                    noise_scale = gr.Slider(
                        minimum=0.1, maximum=2, value=0.6, step=0.1, label="Noise Scale"
                    )
                    noise_scale_w = gr.Slider(
                        minimum=0.1, maximum=2, value=0.8, step=0.1, label="Noise Scale W"
                    )
                    length_scale = gr.Slider(
                        minimum=0.1, maximum=2, value=1, step=0.1, label="Length Scale"
                    )
                    language = gr.Dropdown(
                        choices=languages, value=languages[1], label="Language"
                    )
                    btn = gr.Button("Generate!", variant="primary")
                with gr.Column():
                    text_output = gr.Textbox(label="Message")
                    audio_output = gr.Audio(label="Output Audio")
                    gr.Markdown("# 赛马娘 Bert-VITS2 语音合成\n"
                        "Project page：[GitHub](https://github.com/fishaudio/Bert-VITS2)\n"
                        "- 本项目在日语方面有所欠缺，特别是音调的设计上，需要帮助。\n"
                        "- このプロジェクトは、日本語の方面で不足しています。特に、音調の設計に関して助けが欲しいです。")

            btn.click(
                tts_fn,
                inputs=[
                    text,
                    speaker,
                    sdp_ratio,
                    noise_scale,
                    noise_scale_w,
                    length_scale,
                    language,
                ],
                outputs=[text_output, audio_output],
            )
        with gr.Tab(label="natuki"):
            with gr.Row():
                with gr.Column():
                    text2 = gr.TextArea(
                        label="Text",
                        placeholder="Input Text Here",
                        value="はりきっていこう！",
                    )
                    speaker2 = gr.Dropdown(
                        choices=speakers_2, value=speakers_2[0], label="Speaker"
                    )
                    sdp_ratio2 = gr.Slider(
                        minimum=0, maximum=1, value=0.2, step=0.1, label="SDP Ratio"
                    )
                    noise_scale2 = gr.Slider(
                        minimum=0.1, maximum=2, value=0.6, step=0.1, label="Noise Scale"
                    )
                    noise_scale_w2 = gr.Slider(
                        minimum=0.1, maximum=2, value=0.8, step=0.1, label="Noise Scale W"
                    )
                    length_scale2 = gr.Slider(
                        minimum=0.1, maximum=2, value=1, step=0.1, label="Length Scale"
                    )
                    language2 = gr.Dropdown(
                        choices=languages, value=languages[1], label="Language"
                    )
                    btn2 = gr.Button("Generate!", variant="primary")
                with gr.Column():
                    text_output2 = gr.Textbox(label="Message")
                    audio_output2 = gr.Audio(label="Output Audio")
                    gr.Markdown("# 赛马娘 Bert-VITS2 语音合成\n"
                        "Project page：[GitHub](https://github.com/fishaudio/Bert-VITS2)\n"
                        "- 本项目在日语方面有所欠缺，特别是音调的设计上，需要帮助。\n"
                        "- このプロジェクトは、日本語の方面で不足しています。特に、音調の設計に関して助けが欲しいです。")

            btn2.click(
                tts_fn_2,
                inputs=[
                    text2,
                    speaker2,
                    sdp_ratio2,
                    noise_scale2,
                    noise_scale_w2,
                    length_scale2,
                    language2,
                ],
                outputs=[text_output2, audio_output2],
            )
    app.launch(server_name="0.0.0.0")
