import gradio as gr
import joblib



def values(sepal_length, sepal_height, petal_length, petal_height):
    model = joblib.load('iris-predictor.joblib')
    action = model.predict([[sepal_length, sepal_height, petal_length, petal_height]])
    if action == 'Iris-setosa':
        image_1 = 'Irissetosa1 copy.jpg'
        text1 = 'This is Iris Setosa 💐'
        return text1, image_1
    elif action == 'Iris-virginica':
        image_2 = 'Iris_virginica_2 copy.jpg'
        text2 = 'This is Iris Virginica 🌺'
        return text2, image_2
    elif action == 'Iris-versicolor':
        image_3 = 'iris_versicolor copy.JPG'
        text3 = 'This is Iris Versicolor 🌼'
        return text3, image_3
    else:
        "No Picture to display for your ambiguous values"


sepal_l = gr.inputs.Slider(0.1, 9.9, label='Sepal-Length')
sepal_h = gr.inputs.Slider(0.1, 9.9, label='Sepal-Height')
petal_l = gr.inputs.Slider(0.1, 9.9, label='Petal-height')
petal_h = gr.inputs.Slider(0.1, 9.9, label='Petal-Length')

output = gr.Textbox(label="Result")
output1 = gr.outputs.Image(label="Image Result")


app = gr.Interface(fn=values, inputs=[sepal_l, sepal_h, petal_l, petal_h], outputs=[output, output1], title='An iris flower app',
                   description='Input the Flower Details for Sepal and Petal Respectively.', examples=[[4.7, 3.2, 1.6, 0.2],
                                                                                 [6.0, 2.7, 5.1, 1.6],
                                                                                 [6.5, 3.0, 5.5, 1.8]], live=False, theme='huggingface')



app.launch()