import gradio as gr
from transformers import pipeline

sentiment = pipeline('sentiment-analysis')

def get_sentiment(input_text):
    return sentiment(input_text)

front_end = gr.Interface(fn = get_sentiment,
                        inputs = "text",
                        outputs = ["text"],
                        title = "Toxicity Detector",
                        description = "A simple web-app to find out that text is toxic or not")

front_end.launch(inline=False)