
import numpy as np
import streamlit as st
from PIL import Image, ImageOps
import cv2
from utils import OCR


alert = False
ocr = None

st.title("Optical Character Recognition")

tab_upload, tab_cam = st.tabs(['Upload', 'Camera'])

with tab_upload:
    image_upload = st.file_uploader(
        label='Upload the Image', type=['jpg', 'jpeg', 'png'])

with tab_cam:
    image_webcam = st.camera_input(
        label="Take a picture 📷")
if image_upload:
    image = Image.open(image_upload)
elif image_webcam:
    image = Image.open(image_webcam)
else:
    image = Image.open('./Images/sample_image_1.jpg')

st.image(image=ImageOps.scale(image, factor=0.2))

if st.button('Detect'):

    try:
        pass
        ocr = OCR(image=image)

    except:

        st.warning(
            " Please use a different image.", icon="⚠")
        alert = True


if ocr:
    st.caption("✨Result")

    try:
        st.pyplot(fig=ocr.detection(), use_container_width=True)
    except:
        st.warning(
            " Please use a different image", icon="⚠")


else:
    st.caption('Just click the Detect button')
    if alert:
        st.warning(
            " Please use a different image.", icon="⚠")

    st.image(image)
