import gradio as gr
import tensorflow as tf
import numpy as np

# Load the model
model = tf.keras.models.load_model('model.h5')

# Define the class names
class_names = {
    0: 'Esophagitis',
    1: 'Dyed lifted polyps'
}


def classify_image(image):
    # Preprocess the image
    img_array = tf.image.resize(image, [256, 256])
    img_array = tf.expand_dims(img_array, 0) / 255.0

    # Make a prediction
    prediction = model.predict(img_array)
    predicted_class = tf.argmax(prediction[0], axis=-1)
    confidence = np.max(prediction[0])

    return class_names[predicted_class.numpy()], confidence


iface = gr.Interface(
    fn=classify_image,
    inputs="image",
    outputs=["text", "number"],
    examples=[
        ['examples/0.jpg'],
        ['examples/1.jpg'],
    ])
iface.launch()
