from transformers import pipeline
import gradio as gr
import os 

model = pipeline(model = "AhmadHakami/alzheimer-image-classification-google-vit-base-patch16",
                 task  = "image-classification")

model.model.config.id2label = {
0: 'خفيف الخرف (Mild Demented)',
1: 'متوسط الخرف (Moderate Demented)',
2: 'غير مصاب بالخرف (Non Demented)',
3: 'خفيف جداً الخرف (Very Mild Demented)'
}

examples = []
for image in os.listdir("examples"):
    examples.append(f'examples//{image}')


gr.Interface.from_pipeline(model, 
                           title="Tbyan - تِــبْيان Alzheimer MRI Classification",
                           description="This model fine-tuned using vit-base-patch16-224-in21k by Google, and trained on credible MRI data from Open Access Series of Imaging Studies (OASIS) and the data annotated by experts, it aims to expedite patient results, developed by Tbyan تبيان Team at AI course by `Misk Foundation & Samsung Innovation Campus`, \n **Try it now:**", 
                           examples = examples).launch()

 