import gradio as gr
import openai
import os


# # 设置你的OpenAI API密钥
# openai.api_key = "your_openai_api_key"

# 定义将音频转换为文本的函数
def transcribe_audio(audio):
    os.rename(audio, audio + '.wav')
    audio_file = open(audio + '.wav', "rb")
    # 调用Whisper API进行语音识别
    transcript = openai.Audio.transcribe("whisper-1", audio_file)
    
    # 返回识别的文字
    return transcript["text"]

# 创建Gradio界面
audio_input = gr.inputs.Audio(source="microphone", type="filepath")
text_output = gr.outputs.Textbox()

iface = gr.Interface(fn=transcribe_audio, inputs=audio_input, outputs=text_output,
                     title="Whisper语音识别",
                     description="使用麦克风录制音频并将其转换为文本。")

# 启动Gradio应用
iface.launch()
