import pandas as pd
import openai
from openai.embeddings_utils import cosine_similarity
import os 
openai.api_key = os.environ.get("apk")

def _get_embedding(text, model="text-embedding-ada-002"):
    try:
        text = text.replace("\n", " ")
    except:
        None
    return openai.Embedding.create(input = [text], model=model)['data'][0]['embedding']

def search_hadiths(user_input,nb_hadiths_to_display=10, path_to_json = "embeded_data.json",):
    df = pd.read_json(path_to_json)
    try:
        df["embeddings"] = df.embeddings.apply(lambda x: x["embeding"])
    except:
        pass
    embedding = _get_embedding(user_input, model='text-embedding-ada-002')
    df['similarity'] = df.embeddings.apply(lambda x: cosine_similarity(x, embedding))
    results = df.sort_values('similarity', ascending=False).head(int(nb_hadiths_to_display)).to_dict(orient="records")
    md_results = ""
    i = 1
    for result in results:
        similarity = str(round(result["similarity"]*100,2)) + "%"
        book = result["book"]
        chapter = result["chapter"]
        content = result["content"]
        display = f"## Hadith numéro {i}: Similarité avec la recherche : {similarity}\n## Book : {book}\n## Chapter : {chapter}\n{content}\n\n------\n\n"
        md_results += display
        i += 1
    return md_results