
import gradio as gr
from functools import partial
from get_similar_hadiths import search_hadiths
import pandas as pd

title = "Smart Hadith (Version Française) -> [English version here](https://huggingface.co/spaces/Adr740/Hadith_AI_Explorer)"
desc = "Bienvenue dans Smart Hadith. Smart Hadith est un outil de recherche sémantique de hadith utilisant l'intelligence artificelle. Contact suggestions/questions: [hdthaiexplorer@gmail.com](mailto:hdthaiexplorer@gmail.com)"

# "This is a tool that helps you find quickly relevant hadiths on a topic or a problem you have. Just type in plain English what you are looking for in the box below.\n\n"
warning = "\n\n**AVERTISSEMENT (seulement environ 3000 hadiths sont présents)**\nCET OUTIL EST DESTINÉ À DES FINS DE RÉFÉRENCE AFIN DE FACILITER LA RECHERCHE SUR LES HADITHS (PAROLES ET ACTES PROPHÉTIQUES), IL N'EST PAS DESTINÉ À ÊTRE UTILISÉ COMME OUTIL DE GUIDANCE OU DANS TOUT AUTRE BUT. LES UTILISATEURS SONT RESPONSABLES DE CONDUIRE LEURS PROPRES RECHERCHES ET DE DEMANDER DES CONSEILS AUX SAVANTS RELIGIEUX.\nVEUILLEZ NOTER QUE LE CONTENU AFFICHÉ PAR CET OUTIL N'EST PAS GARANTI COMME ÉTANT PRÉCIS, COMPLET OU À JOUR, ET N'EST PAS DESTINÉ À ÊTRE UTILISÉ COMME SOURCE RELIGIEUSE UNIQUE.\nLES DÉVELOPPEURS DE CET OUTIL NE SERONT PAS TENUS RESPONSABLES DE TOUTE DÉCISION OU UTILISATION FAITE PAR LES UTILISATEURS DE CET OUTIL."
disclaimer = "\n## DISCLAIMER\n\nTHIS TOOL IS INTENDED FOR REFERENCE PURPOSES ONLY AND IS NOT INTENDED TO BE TAKEN AS RELIGIOUS ADVICE. THE HADITHS DISPLAYED BY THIS TOOL ARE NOT INTENDED TO BE USED AS A SOLE SOURCE OF RELIGIOUS GUIDANCE. USERS ARE RESPONSIBLE FOR CONDUCTING THEIR OWN RESEARCH AND SEEKING GUIDANCE FROM RELIGIOUS SCHOLARS.\n\nPLEASE NOTE THAT THE CONTENT DISPLAYED BY THIS TOOL IS NOT GUARANTEED TO BE ACCURATE, COMPLETE, OR UP-TO-DATE.\n\nTHE DEVELOPERS OF THIS TOOL WILL NOT BE HELD RESPONSIBLE FOR ANY DECISIONS MADE BY THE USERS OF THIS TOOL THAT ARE BASED ON THE CONTENT DISPLAYED BY THIS TOOL.\n\nHadiths gathered from this repository: https:\/\/www.kaggle.com\/datasets\/fahd09\/hadith-dataset"
def iter_grid(n_rows, n_cols):
    for _ in range(n_rows):
        with gr.Row():
            for _ in range(n_cols):
                with gr.Column():
                    yield
with gr.Blocks(title=title) as demo:
    gr.Markdown(f"## {title}")
    gr.Markdown(desc+warning)
    # gr.Markdown(warning)
    with gr.Row():
        with gr.Column(scale=4):
            text_area = gr.Textbox(placeholder="Écrivez ici... Exemple: 'Hadiths sur le bon comportement et la nourriture'", lines=3, label="Décrivez avec vos mots ce que vous recherchez (mot-clé, sujet etc...)")
        with gr.Column(scale=1):
            number_to_display = gr.Number(value=10,label = "Nombre de hadiths à afficher")        
            submit_button = gr.Button(value="Trouver des hadiths")    
            pass

    fn = partial(search_hadiths)
    
    with gr.Accordion("Tous les résultats:"):
        ll = gr.Markdown("Vide")

    
    submit_button.click(fn=fn, inputs=[text_area,number_to_display], outputs=[ll])



demo.launch( enable_queue=True,max_threads=40)