import pandas as pd
import openai
from data import data as df
import numpy as np
import os

openai.api_key = os.environ.get("apk")

def cosine_similarity(a, b):
    return np.dot(a, b) / (np.linalg.norm(a) * np.linalg.norm(b))


def get_embedding(text, model="text-embedding-ada-002"):
    try:
        text = text.replace("\n", " ")
    except:
        None
    return openai.Embedding.create(input = [text], model=model)['data'][0]['embedding']

def search_hadiths(search, nb=3, pprint=True):
    embedding = get_embedding(search, model='text-embedding-ada-002')
    dff = df.copy()
    dff['similarities'] = dff.embeding.apply(lambda x: cosine_similarity(x, embedding))
    res = dff.sort_values('similarities', ascending=False).head(int(nb))
    try:
        res.drop(columns=["id","hadith_id", "embeding"], inplace=True)
    except:
        pass
    return res

def get_hadiths(text, nb):
    result = search_hadiths(text,nb).to_dict(orient="records")
    final_str = ""
    for r in result:
        final_str += "### Source: " + str(r["source"]) + " | Chapter name : "+ str(r["chapter"]) +" | Chapter number: " + str(r["chapter_no"]) + " | Hadith number : " +  str(r["chapter_no"]) + "\n\n"
        final_str += "Similarity with query: " + str(round(r["similarities"]*100,2)) + "%" +" | Chain index: " + str(r["chain_indx"]) + "\n\n"
        final_str += "### Hadith content:" + "\n\n" + str(r["text_en"]) + "\n\n"
        final_str += "Arabic version: \n\n" + str(r["text_ar"])
        final_str += "\n\n-----------------------------------------------------------------------------------------------------\n\n"
        
    final_str = final_str.replace("`", "")
    return  final_str
