import gradio as gr
from functools import partial
from get_hadith import get_hadiths
import pandas as pd

title = "Hadith AI Explorer"
desc = "This is a tool that helps you find quickly relevant hadiths on a topic or a problem you have. Just type in plain English what you are looking for in the box below. Contact suggestions/questions: hdthaiexplorer@gmail.com\n\n"
warning = "Warning!\n **PLEASE READ THE DISCLAIMER BELOW** This isn't a 100% accurate tool and not all the Hadiths are present in the database and some results might be repetitive. If it's the case, try generating more Hadiths with the selector.\nMore informations describing how the tool works are coming soon"
disclaimer = "## DISCLAIMER\n\nTHIS TOOL IS INTENDED FOR REFERENCE PURPOSES ONLY AND IS NOT INTENDED TO BE TAKEN AS RELIGIOUS ADVICE. THE HADITHS DISPLAYED BY THIS TOOL ARE NOT INTENDED TO BE USED AS A SOLE SOURCE OF RELIGIOUS GUIDANCE. USERS ARE RESPONSIBLE FOR CONDUCTING THEIR OWN RESEARCH AND SEEKING GUIDANCE FROM RELIGIOUS SCHOLARS.\n\nPLEASE NOTE THAT THE CONTENT DISPLAYED BY THIS TOOL IS NOT GUARANTEED TO BE ACCURATE, COMPLETE, OR UP-TO-DATE.\n\nTHE DEVELOPERS OF THIS TOOL WILL NOT BE HELD RESPONSIBLE FOR ANY DECISIONS MADE BY THE USERS OF THIS TOOL THAT ARE BASED ON THE CONTENT DISPLAYED BY THIS TOOL.\n\nHadiths gathered from this repository: https:\/\/www.kaggle.com\/datasets\/fahd09\/hadith-dataset"
def iter_grid(n_rows, n_cols):
    for _ in range(n_rows):
        with gr.Row():
            for _ in range(n_cols):
                with gr.Column():
                    yield
with gr.Blocks(title=title) as demo:
    gr.Markdown(f"## {title}")
    gr.Markdown(desc)
    gr.Markdown(warning)
    with gr.Row():
        with gr.Column(scale=4):
            text_area = gr.Textbox(placeholder="Write here", lines=3, label="Describe your topic or what you are looking for")
        with gr.Column(scale=1):
            number_to_display = gr.Number(value=10,label = "Number of Hadiths to display")        
            submit_button = gr.Button(value="Search for hadiths")    
            pass

    fn = partial(get_hadiths)
    
    with gr.Accordion("All results:"):
        ll = gr.Markdown("Empty")
    gr.Markdown(disclaimer)

    submit_button.click(fn=fn, inputs=[text_area,number_to_display], outputs=[ll])



demo.launch( enable_queue=True,max_threads=40)