import gradio as gr
from functools import partial
import os
from get_cv import get_cv

title = "CV Indexing par Intelligence Artificielle"
desc = "Ceci est un outil qui vous aide à trouver rapidement des CV pertinents en fonction des descriptions de poste. Il suffit de taper simplement ce que vous recherchez dans la zone ci-dessous.\n\n Avec l'aide de l'IA, cet outil est conçu pour simplifier votre recherche de CV en suggérant des résultats qui correspondent le mieux à vos besoins. Vous n'avez qu'à saisir les termes pertinents qui décrivent le poste que vous recherchez et l'outil vous présentera une liste de CV adaptés à vos critères. Cela vous permettra de gagner du temps et de trouver plus facilement les candidats idéaux pour votre entreprise.\n\n"
# warning = "Warning!"
disclaimer = "#### Attention! La méthode utilisée est stochastique et par conséquent les résultats peuvent parfois ne pas respecter parfaitement la requête. SI CELA ARRIVE : essayez d'adapter votre demande en reformulant ou en fournissant plus d'informations, cela fonctionne mieux avec des textes plus longs (fiche de poste par exemple)"
def iter_grid(n_rows, n_cols):
    for _ in range(n_rows):
        with gr.Row():
            for _ in range(n_cols):
                with gr.Column():
                    yield
with gr.Blocks(title=title) as demo:
    gr.Markdown(f"## {title}")
    gr.Markdown(desc)
    gr.Markdown(disclaimer)
    with gr.Row():
        with gr.Column(scale=4):
            text_area = gr.Textbox(placeholder="Écrivez ici", lines=3, label="Décrivez le type de candidat que vous chechez ou copiez collez une fiche de poste")
        with gr.Column(scale=1):
            number_to_display = gr.Number(value=10,label = "Nombre de candidats à afficher")        
            submit_button = gr.Button(value="Rechercher des candidats")    
            pass

    fn = partial(get_cv)
    
    with gr.Accordion("Tous les résultats:"):
        ll = gr.Markdown("Vide")


    submit_button.click(fn=fn, inputs=[text_area,number_to_display], outputs=[ll])

login = os.environ.get("login")
pwd = os.environ.get("pwd")
demo.launch(enable_queue=True,max_threads=40)
