import streamlit as st
import pandas as pd
import smtplib

# Custom CSS for fancy styling
st.markdown("""
    <style>
        .big-title {
            font-size: 48px !important;
            color: lime;
            text-shadow: 3px 3px 3px red;
        }
        .sub-title {
            font-size: 24px;
            color: green;
            text-shadow: 1px 1px 1px red;
        }
    </style>
""", unsafe_allow_html=True)

st.markdown("<div class='big-title'>THE IPN APP BY:</div>", unsafe_allow_html=True)
st.markdown("<div class='sub-title'>Citibank Demo Business Inc.</div>", unsafe_allow_html=True)

class PromissoryNote:
    def __init__(self, instrument_id, order_of, place_issued, date_issued, 
                 numeric_amount, amount, debtor_name, autograph_date):
        self.instrument_id = instrument_id
        self.order_of = order_of
        self.place_issued = place_issued
        self.date_issued = date_issued
        self.numeric_amount = numeric_amount
        self.amount = amount
        self.debtor_name = debtor_name
        self.autograph_date = autograph_date

    def get_details(self):
        return {
            'Instrument ID': self.instrument_id,
            'Order Of': self.order_of,
            'Place Issued': self.place_issued,
            'Date Issued': self.date_issued,
            'Numeric Amount': self.numeric_amount,
            'Amount': self.amount,
            'Debtor Name': self.debtor_name,
            'Autograph Date': self.autograph_date
        }

    def create_note(self):
        return f'WORLD CITIZENS OF THE SOLAR MONMATIA INTERNATIONAL PROMISSORY NOTE...\n{self.get_details()}...ANY ALTERATION OR ERASURE VOIDS THIS CERTIFICATE...'

def send_email(note_details):
    # Dummy email sending function
    pass

def save_to_csv(note_details):
    # Convert the note details dictionary to a DataFrame
    df = pd.DataFrame([note_details])
    # Append the note details to an existing CSV file
    df.to_csv('promissory_notes.csv', mode='a', header=False)

def main():
    st.title("Promissory Note Generator")

    instrument_id = st.text_input("Enter the instrument ID: ")
    order_of = st.text_input("Enter the order of: ")
    place_issued = st.text_input("Enter the place issued: ")
    date_issued = st.date_input("Enter the date issued: ")
    numeric_amount = st.text_input("Enter the numeric amount: ")
    amount = st.text_input("Enter the amount: ")
    debtor_name = st.text_input("Enter the debtor name: ")
    autograph_date = st.date_input("Enter the autograph date: ")

    if st.button("Generate Note"):
        new_note = PromissoryNote(instrument_id, order_of, place_issued, date_issued, numeric_amount, 
                                  amount, debtor_name, autograph_date)
        note_details = new_note.get_details()

        # Display Note
        st.text_area("Generated Note:", new_note.create_note())

        # Save to CSV
        save_to_csv(note_details)
        st.success('Note saved to CSV.')

        # Send Email Notification (dummy function, replace with actual code)
        send_email(note_details)
        st.success('Email notification sent.')

if __name__ == '__main__':
    main()