# Import the requests and BeautifulSoup libraries
import requests
from bs4 import BeautifulSoup
import streamlit as st

# Define the URL of the website you want to interact with
url = 'https://www.iana.org/domains/root/db'

st.title("LiveChecker: Live Site Validator")
st.write("This code finds and shows active websites with a specific term like google or example")

user_input = st.text_input('Enter a website name', placeholder='google').strip() or "google"

if st.button("Start checking"):
  progress_bar = st.progress(0)
  # Try to send a GET request to the URL and read the HTML content
  try:
      response = requests.get(url)
      response.raise_for_status()
      html = response.text
  except requests.exceptions.RequestException as e:
      st.write('Request Error:', e, url)

  if html:
    # Create a Python list from domain texts using BeautifulSoup
    domain_list = [link.get_text().strip() for link in BeautifulSoup(html, 'html.parser').find_all('a', href=lambda x: x and x.startswith('/domains/root/db/'))]
    domain_list = [domain for domain in domain_list if domain.isascii()]
    
    def check_website():
      # Get the total number of domain names in the list
      total = len(domain_list)
      # Initialize a counter for completed domain names
      count = 0
      # Loop through each domain name and check if the website is live or not
      for domain in domain_list:
          # Add the domain name to the base URL of yomovies website
          user_input_url = 'www.' + user_input + domain
          outputtext = ''

          try:
              response = requests.get('https://' + user_input_url,stream=True,timeout=2)
              status_code = response.status_code
              outputtext = 'https://' + user_input_url
          except:
              # If https fails, try again with http
              try:
                  response = requests.get('http://' + user_input_url,stream=True,timeout=2)
                  status_code = response.status_code
                  outputtext = 'http://' + user_input_url
              except:
                  # If both fail, set status code to None
                  status_code = None
          # Print the result based on the status code
          if status_code == 200:
              st.write(outputtext, 'is live ✅')
          # Increment the counter by one
          count += 1
          # Calculate the percentage of completion and update the progress bar value
          percent = int(count / total * 100)
          progress_bar.progress(percent)
    check_website()