# https://huggingface.co/tuner007/pegasus_paraphrase

import nltk
from nltk import sent_tokenize
nltk.download('punkt')

import gradio as gr

import torch
from transformers import PegasusForConditionalGeneration, PegasusTokenizer

import warnings
warnings.filterwarnings('ignore')

model_name = 'tuner007/pegasus_paraphrase'
torch_device = 'cuda' if torch.cuda.is_available() else 'cpu'
tokenizer = PegasusTokenizer.from_pretrained(model_name)
model = PegasusForConditionalGeneration.from_pretrained(model_name).to(torch_device)

def paraphraser(input_text,num_return_sequences=1):
  sentence_list = sent_tokenize(input_text)

  output = []
  for sentence in sentence_list:
    batch = tokenizer.prepare_seq2seq_batch([sentence],truncation=True,padding='longest',max_length=60, return_tensors="pt").to(torch_device)
    translated = model.generate(**batch,max_length=60,num_beams=10, num_return_sequences=num_return_sequences, temperature=1.5)
    tgt_text = tokenizer.batch_decode(translated, skip_special_tokens=True)
    output.extend(tgt_text)

  paraphrase = [' '.join(x for x in output)]
  paraphrased_text = str(paraphrase).strip('[]').strip("'")

  return paraphrased_text
  
paraphraseUI = gr.Interface(fn=paraphraser, inputs='textbox', outputs='text', title="ParaPhraser", theme='dark')
paraphraseUI.launch(inbrowser=True, share=True)