import gradio as gr 
from transformers import pipeline
sentiment = pipeline('sentiment-analysis')
def get_sentiment(input_text):
  return sentiment (input_text)
iface = gr.Interface(fn = get_sentiment,
                     inputs = 'text',
                     outputs = ['text'],
                     title = 'Sentiment Analysis',
                     examples = ['The movie was very bad', 'Every day is a new opportunity.'],
                     article = 'This project is for software engineering with team members Aditya Jadhav, Sujal Kuthe, Sujal Wakalkar, and Adesh Ingle. We developed a web application for sentiment analysis that takes text data as input and classifies whether it is positive or negative.',
                     thumbnail = '/content/sentiment-analysis.png',
                     theme = gr.themes.Soft())
iface.launch()