import numpy as np
import os
import keras
import pandas as pd
import seaborn as sns
import matplotlib.pyplot as plt
from keras.models import Sequential
from PIL import Image
from keras.layers import Conv2D, Flatten, Dense, Dropout, BatchNormalization, MaxPooling2D
from sklearn.preprocessing import OneHotEncoder
import pickle
import tensorflow as tf
import gradio as gr

model_path = "model.h5"
model = tf.keras.models.load_model(model_path)

# Define the labels
labels = ['Non Demented', 'Mild Dementia', 'Moderate Dementia', 'Very Mild Dementia']

# Define the prediction function
def predict_dementia(image):
    img = Image.fromarray(image.astype('uint8'))
    img = img.resize((128, 128))
    img = np.array(img)
    img = img.reshape(1, 128, 128, 3)
    
    prediction = model.predict(img)
    prediction_class = np.argmax(prediction)
    return labels[prediction_class]

# Create the Gradio interface
iface = gr.Interface(
    fn=predict_dementia,
    inputs="image",
    outputs="text",
    title="Deep Learning-Based Classification of Dementia Stages Using Brain Images",
    description="Dementia is a neurodegenerative disorder characterized by a decline in cognitive abilities. Early detection and classification of dementia stages are crucial for effective treatment and care. In this study, we propose a deep learning-based approach for classifying dementia stages using brain images. The objective is to develop a model that can accurately differentiate between different stages of dementia, including non-demented, mild dementia, moderate dementia, and very mild dementia.",
    article=''' To achieve this, we utilize a dataset consisting of brain images from individuals with varying dementia stages. The dataset is preprocessed to ensure uniformity and eliminate noise. A convolutional neural network (CNN) architecture is designed and trained on the preprocessed images. The model incorporates multiple convolutional layers, batch normalization, max pooling, and dropout layers to capture relevant features from the images. The training procedure involves optimizing the model using the Adamax optimizer and minimizing the categorical cross-entropy loss.
The performance of the proposed model is evaluated using various metrics, including accuracy, validation accuracy, loss and validation loss. Additionally, a comparison is made with existing approaches for dementia classification to assess the effectiveness of the proposed method. The results demonstrate promising classification accuracy and highlight the potential of deep learning techniques in accurately diagnosing and classifying dementia stages based on brain images.
The findings of this study contribute to the field of dementia research by providing a reliable and automated method for dementia classification. The developed model can assist medical professionals in early diagnosis and treatment planning, potentially improving patient outcomes and quality of life. Further research and refinement of the model could lead to more accurate and efficient diagnosis of dementia, enabling timely intervention and support for affected individuals
''',
    examples=[["Non(1).jpg"],["Mild.jpg"],["Moderate.jpg"],["Very(1).jpg"]],
    allow_flagging=False
)

iface.launch(debug=True)