# -*- coding: utf-8 -*-
""" Gradio PCOS Prediction .ipynb

Automatically generated by Colaboratory.

The original file is located at
    https://colab.research.google.com/drive/1W2dPPr1tHmTDgMgZML6C1Ch-4p_tOeZR
"""

import pandas as pd
import gradio as gr
import numpy as np
import seaborn as sns
import matplotlib.pyplot as plt
import sklearn
from sklearn import tree
from sklearn.linear_model import LinearRegression
from sklearn.linear_model import LogisticRegression
from sklearn.tree import DecisionTreeClassifier
from sklearn.preprocessing import scale
from sklearn.model_selection import train_test_split
from sklearn.metrics import confusion_matrix
from sklearn.preprocessing import StandardScaler
def main(Follicle_No_Right,Follicle_No_Left,Skin_darkening,Hair_growth,Weight_gain,Cycle):
  url="https://raw.githubusercontent.com/Athulg19/datasets/main/PCOS_clean_data_without_infertility.csv"
  data = pd.read_csv(url) 
  data=pd.DataFrame(data)
  data=data.astype(np.float64)
  data.dtypes
  correlation=data.corrwith(data['PCOS (Y/N)']).abs().sort_values(ascending=False)
  correlation=correlation[correlation>0.4].index
  data=data[correlation]
  arr=data.values                     
  X=arr[:,1:6]                        
  Y=arr[:,0]
  scaler=StandardScaler().fit(X)              
  rescaledX=scaler.transform(X) 
  np.set_printoptions(precision=3)
  y=data['PCOS (Y/N)']
  x=data.drop(['PCOS (Y/N)'],axis=1)
  X_train,X_test,y_train,y_test = train_test_split(x,y,test_size=.25)
  logistic = LogisticRegression()
  logistic.fit(X_train,y_train)
  data = {'Follicle No. (R)':Follicle_No_Right,'Follicle No. (L)':Follicle_No_Left,'Skin darkening (Y/N)':Skin_darkening,'hair growth(Y/N)':Hair_growth,'Weight gain(Y/N)':Weight_gain,'Cycle(R/I)':Cycle}
  index = [0]
  cust_df = pd.DataFrame(data, index)
  costpredLog = logistic.predict(cust_df)
  if costpredLog ==0:
    Prediction = "There is less chance for the patient to catch PCOS"
  else:
    Prediction = "There is more chance for the patient to catch PCOS."
  return  Prediction

iface = gr.Interface(fn = main,
                     
inputs =['number','number','number','number','number','number'],

outputs =['text'],

title="Onset of PCOS prediction",

description ='''    Description
 
Polycystic ovary syndrome (PCOS) is a problem with hormones that happens during the reproductive years. If you have PCOS, you may not have periods very often.
Or you may have periods that last many days. You may also have too much of a hormone called androgen in your body.
With PCOS, many small sacs of fluid develop along the outer edge of the ovary. These are called cysts. The small fluid-filled cysts contain immature eggs. 
These are called follicles. The follicles fail to regularly release eggs.
The exact cause of PCOS is unknown. Early diagnosis and treatment along with weight loss may lower the risk of long-term complications such as type 2 diabetes and heart disease.

    Output0 - Describes the Prediction made


More details about the Inputs taken and how they needed to be taken are given below:

          Follicle_No_Right = Number of follicles is in Right Overy 
          Follicle_No_Left = Number of follicles is in Left Ovary 
          Skin_darkening = yes(1)/No(0)
          Hair_growth = yes(1)/No(0)
          Weight_gain = yes(1)/No(0)
          Cycle = If it is Regular (0) or Irregular (1)
         
         
''',
article='''
Complications of PCOS can include:

          * Infertility

          * Gestational diabetes or pregnancy-induced high blood pressure

          * Miscarriage or premature birth

          * Nonalcoholic steatohepatitis — a severe liver inflammation caused by fat accumulation in the liver

          * Metabolic syndrome — a cluster of conditions including high blood pressure, 
                            high blood sugar, and abnormal cholesterol or triglyceride levels that significantly increase your risk of cardiovascular disease

          * Type 2 diabetes or prediabetes

          * Sleep apnea

          * Depression, anxiety and eating disorders

          * Abnormal uterine bleeding

          * Cancer of the uterine lining (endometrial cancer)''')

iface.launch(debug =True)