import pandas as pd 
import numpy as np
import matplotlib.pyplot as plt
import seaborn as sns
import gradio as gr
from sklearn.preprocessing import LabelEncoder
from sklearn.model_selection import train_test_split
from sklearn.ensemble import RandomForestRegressor
from sklearn.linear_model import LinearRegression
from sklearn.metrics import r2_score
from sklearn.model_selection import KFold
from sklearn.model_selection import cross_val_score
from sklearn.preprocessing import StandardScaler
def main(Age,Sex,BMI,No_of_Children,Smoker,Region):
  url="https://raw.githubusercontent.com/ADITHYASNAIR2021/Dataset-cart/main/insurance.csv"
  data = pd.read_csv(url)
  label_data = data.copy()
  s = (data.dtypes =="object")
  object_cols = list(s[s].index)
  label_encoder = LabelEncoder()
  for col in object_cols:
      label_data[col] = label_encoder.fit_transform(label_data[col])
  X= label_data.drop(["expenses"],axis =1)
  y= label_data["expenses"]
  X_train, X_rem, y_train, y_rem = train_test_split(X, y, train_size = 0.25, random_state = 42)
  X_valid, X_test, y_valid, y_test = train_test_split(X_rem, y_rem, test_size = 0.5, random_state = 42)
  X_train = StandardScaler().fit_transform(X_train)
  X_test = StandardScaler().fit_transform(X_test)

  Rand_reg=RandomForestRegressor()
  Rand_reg.fit(X_train,y_train)

  Lin_reg = LinearRegression()
  Lin_reg.fit(X_train,y_train)
  
  data = {'age':Age,'sex':Sex,'bmi':BMI,'children':No_of_Children,'smoker':Smoker,'region':Region}
  index = [0]
  cust_df = pd.DataFrame(data, index)

  costpredRand = Rand_reg.predict(cust_df)
  costpredLin = Lin_reg.predict(cust_df)

  large=[costpredLin,costpredRand]
  #large.sort(reverse=True)
  if large[0] <= 0 and large[1]<=0:
    return 'No values found, 404 error'
  if large[0] <= 0 and large[1]>0:
    return f"The amount to be paid at the hospital for the mentioned patient is- {large[1]}"
  if large[0] >0  and large[1] <= 0:
    return f"The amount to be paid at the hospital for the mentioned patient is- {large[0]}"
  if large[0] >=0  and large[1] >=0:
    return f"The amount to be paid at the hospital for the mentioned patient is- {large[1]}"

iface = gr.Interface(fn = main,
                     
inputs =['number','number','number','number','number','number'],

outputs =['text'],

title=" 🩺 Medical cost prediction ",

description ='''    Description

          Age: age of the primary beneficiary

          Sex: insurance contractor gender, female = 0, male = 1

          BMI: Body mass index, providing an understanding of the body, weights that are relatively high or low relative to height,
                objective index of body weight (kg / m ^ 2) using the ratio of height to weight, ideally 18.5 to 24.9

          No_of_Children: Number of children covered by health insurance / Number of dependents

          Smoker: Smoking (Yes(1)/No(0))

          Region: the beneficiary's residential area in the US, northeast =0, northwest =1, southeast = 2, and southwest = 3

''',
                     article='''
                     🩺 Medical Cost Prediction
A regression model that predicts medical cost with an accuracy above 85% 
''',
examples=[[19,0,27.9,0,1,3],[32,1,28.9,0,0,1]])

iface.launch(debug =True)