#Model start

import numpy as np # linear algebra
import pandas as pd # data processing, CSV file I/O (e.g. pd.read_csv)
import matplotlib.pyplot as plt
import gradio as gr
from sklearn.model_selection import train_test_split
from sklearn.linear_model import LogisticRegression
from sklearn.metrics import accuracy_score
from sklearn.model_selection import cross_val_score
from sklearn.metrics import r2_score
  
def main(Pregnancies,Glucose_level,BP,skin_thickness,Insulin,BMI,Diabetes_Function,Age):

  url="https://raw.githubusercontent.com/ADITHYASNAIR2021/Dataset-cart/main/diabetes.csv"
  diabetes_df = pd.read_csv(url)
  diabetes_df = diabetes_df.values
  X= diabetes_df[:,0:8] #Predictors
  y = diabetes_df[:,8] #Target 
  X_train,X_test,y_train,y_test = train_test_split(X,y,test_size=.25)

  Log_reg = LogisticRegression(fit_intercept=True,C=1e15,solver='newton-cg',max_iter=300,penalty='l2',multi_class='ovr')
  Log_reg.fit(X_train,y_train)
  Log_pred = Log_reg.predict(X_test)

  #Accuracy
  lor_accuracy = accuracy_score(y_test,Log_pred)

  #Cross Validation
  logreg = LogisticRegression(max_iter=1500)
  scores_Log = cross_val_score(logreg , X_train , y_train , cv=20)
  scores_Log = scores_Log.mean()

  data = {'Pregancies':Pregnancies,'Glucose':Glucose_level,'BloodPressure':BP,'SkinThickness':skin_thickness,'Insulin':Insulin,'BMI':BMI,'DiabetesPedigreeFunction':Diabetes_Function,'Age':Age}
  index = [0]
  cust_df = pd.DataFrame(data, index)
  
  # Main output prediction 
  costpredLog = Log_reg.predict(cust_df)

  #Get the patients BMI information 

  if BMI == 0: 
        Bmi_eval="NA"

  elif BMI < 18.5: 
         Bmi_eval="You are Underweight" 

  elif BMI < 24.9: 
        Bmi_eval =" You have Normal weight"

  elif BMI >= 25 and BMI < 29.9: 
        Bmi_eval = " You are Pre Obese"

  elif BMI >= 30 and BMI < 34.9: 
        Bmi_eval = " You have class 1 Obesity "

  elif BMI >= 35 and BMI < 39.9: 
        Bmi_eval = " You have class 2 Obesity "

  elif BMI >= 40: 
        Bmi_eval ="You have class 3 obesity "

  else: 
       Bmi_eval = BMI

   # Get the patient's Diabetic information 

  if Glucose_level == 0: 
        Glucose_Eval ="NA"
    
  elif Glucose_level <= 140: 
        Glucose_Eval="You have a Normal Glucose Level"
    
  elif Glucose_level > 140 and Glucose_level < 198: 
        Glucose_Eval="you have Impaired Glucose Tolerance"
        
  elif Glucose_level > 198: 
        Glucose_Eval="You have a high Glucose Level "
        
  else: 
        Glucose_Eval = Glucose_level

 # Final prediction 

  if costpredLog ==0:
    Prediction = "There is less chance for the patient to catch diabetes"

  else:
    Prediction = "There is more chance for the patient to catch diabetes."

  return  Prediction,Bmi_eval,Glucose_Eval

iface = gr.Interface(fn = main,
                     
inputs =['number','number','number','number','number','number','number','number'],

outputs =['text','text','text'],

title="Onset of Diabetes prediction",

examples=[[2,120,120,25,20,25,1,25],[5,200,200,50,160,30,2,30]],

description ='''    Description
 
Some health issues are more serious than others. An example of a severe health issue is diabetes, which is an all-too-common condition
It is essential for people with diabetes to be diagnosed and treated as soon as possible, as high blood sugar levels can damage body organs and tissue,
resulting in complications such as nerve damage, kidney damage, heart attacks, strokes, peripheral vascular disease etc. While some risk factors of 
developing diabetes cannot be changed, healthy lifestyle choices can dramatically reduce a person’s chances of developing it. 

As we face these high numbers of diabetes and prediabetes cases, it’s important that everyone learns as much as they can about recognizing and preventing diabetes. 
All these points emphasise that diabetes can be really bad if not diagnosed properly so, 
with this AI tool, we can predict the onset of diabetes among people which will help them to adjust their lifestyles and other things correctly to prevent diabetes in the future.
                     

    Output0 - Describes the Prediction made
    Output1 - Analyse BMI
    Output2 - Analysis of Glucose level


More details about the Inputs taken and how they needed to be taken are given below:
    * Pregnancies (number of times pregnant)
    * glucose - two-hour plasma glucose concentration after 75g anhydrous glucose in mg/dl (Can check using a Glucometer at home, or at a clinic)
    * Blood Pressure (Diastolic Blood Pressure in mmHg)
    * Skin Thickness (Triceps skin fold thickness in mm)
    * Insulin Resistance (2 h serum insulin in mu U/ml)( Results could be obtained from a Clinic )
    * BMI (Body Mass Index in kg/m2), BMI can be calculated using the equation  = Weight/(Height²)
    * Age (years)
    * Pedigree Diabetes Function ('function that represents how likely they are to get the disease by extrapolating from their ancestor’s history )
      Generally, it's between 0 - 2.5, if there wasn't any ancestorial history of diabetes you can choose between 0 and 1, 
      and if there is any so can select between 1 - 2.5 regarding the seriousness of the family.
''',

article=''' Website created with Gradio for Hackathon'22

Dataset used is:- PIMA INDIANS DIABETES DATASET 

Description of the dataset used:- The Pima Indian Diabetes Dataset, originally from the National Institute of Diabetes and Digestive and Kidney Diseases 
contains information on 768 women from a population near Phoenix, Arizona, USA. The outcome tested was Diabetes, 258 tested positive and 500 tested negative. 
Therefore, there is one target (dependent) variable and the following attributes (TYNECKI, 2018):

To know more about the Tricep skin fold thickness measure 
visit this link:- https://ibb.co/4NDNNx1

Dataset Link - https://www.kaggle.com/datasets/uciml/pima-indians-diabetes-database

Reference 1 = https://rpubs.com/ikodesh/53189

Reference 2 = https://www.diabetes.co.uk/oral-glucose-tolerance-test.html 

''')

iface.launch(debug =True)