import re
import nltk
import numpy as np
import pandas as pd
from nltk.corpus import stopwords
from nltk.stem import WordNetLemmatizer
from nltk.tokenize import word_tokenize
from sklearn.feature_extraction.text import TfidfTransformer,CountVectorizer,TfidfVectorizer

nltk.download('stopwords')
nltk.download('wordnet')
nltk.download('punkt')

class KeywordExtraction:
    
    @staticmethod
    def fit(text):
        wnl = WordNetLemmatizer()
        processed_re_text = re.sub("[^\s\w]"," ",text).lower()
        stopwords_corpus = stopwords.words("english")
        tokenized_text = word_tokenize(processed_re_text)
        processed_text = []

        for i in tokenized_text:
            if i not in stopwords_corpus:
                processed_text.append(wnl.lemmatize(i))
        return " ".join(processed_text)
    
    @staticmethod
    def train(processed_text, top_n=5):
        tfidf_vectorizer = TfidfVectorizer()
        tfidf_matrix = tfidf_vectorizer.fit_transform(processed_text)
        feature_names = tfidf_vectorizer.get_feature_names_out()
        idf_scores = tfidf_vectorizer.idf_
        
        idf_df = pd.DataFrame({'Word': feature_names, 'IDF': idf_scores})
        idf_df = idf_df.sort_values(by='IDF', ascending=False).head(top_n)
        
        return idf_df