from model import KeywordExtraction
import streamlit as st


Model = KeywordExtraction()
st.title("Keyword Extractor")

with st.form(key = "clf_form"):
    text_input_area = st.text_area("Type your text here: ")
    submit_btn = st.form_submit_button(label = "Submit")
    countOfWords = len(text_input_area.split())

    if submit_btn:
        if text_input_area == "":
            st.error("Enter something in order to Extract the keywords of it.",icon="⛔️")
        else:
            if countOfWords<=50:
                st.warning("Pls enter more than 100 words in order to extract keywords of it.",icon="⚠️")
            else:
                st.subheader("Output: ")
                col1,col2 = st.columns(2)
                f1 = Model.fit(text=text_input_area)
                f2 = [f1]
                output = Model.train(f2,top_n= 5)
                with col1:
                    st.info("Text: ")
                    st.write(text_input_area)

                with col2:
                    st.info("Keywords Generated: ")
                    st.write(output)
