import gradio as gr
from fastai.vision.all import *
import skimage

learn = load_learner('mushroom.pkl')

labels = learn.dls.vocab
def predict(img):
    img = PILImage.create(img)
    pred,pred_idx,probs = learn.predict(img)
    return {labels[i]: float(probs[i]) for i in range(len(labels))}

title = "Is It Fly"
description = "Is it a mushroom, or is it a gnome? Produced for Lesson 2 2022 of the FastAI course. Try a sample image or upload a Garden Gnome or a Fly agaric Mushroom - those two classifiers are it's whole world... for now.  PS: It's an Alpha prototype and not to be trusted."
article="<p style='text-align: center'><a href='https://tmabraham.github.io/blog/gradio_hf_spaces_tutorial' target='_blank'>Blog post</a></p>"
examples = ['is it fly sample1.png', 'is it a gnome1.png','is_it_fly_sample.jpg']
interpretation='default'
enable_queue=True

gr.Interface(fn=predict,inputs=gr.inputs.Image(shape=(512, 512)),outputs=gr.outputs.Label(num_top_classes=3),title=title,description=description,article=article,examples=examples,interpretation=interpretation,enable_queue=enable_queue).launch()