import gradio as gr
import os
import sys
from pathlib import Path
import random
import string
import time
from queue import Queue
from threading import Thread
import emoji

text_gen=gr.Interface.load("spaces/AchyuthGamer/MagicPrompt-Stable-Diffusion")
def get_prompts(prompt_text):
    if prompt_text:
	    return text_gen(prompt_text + ", realistic, 8k, cyberpunk, highly detailed, ultra super realism, realism, high graphics, key visual, intricate, highly detailed, breathtaking beauty, precise lineart, vibrant, comprehensive cinematic, trending on DIGITAL ART WEBSITE, best quality, ultra sharp focus, 8k, artgerm")
    else:
        return text_gen("")
proc1=gr.Interface.load("models/AchyuthGamer/ImMagician-Fantasy")

def restart_script_periodically():
    while True:
        random_time = random.randint(540, 600)
        time.sleep(random_time)
        os.execl(sys.executable, sys.executable, *sys.argv)


restart_thread = Thread(target=restart_script_periodically, daemon=True)
restart_thread.start()


queue = Queue()
queue_threshold = 50

#Don't add noise to the first picture no matter what (the point of noise is to get varied outputs, the first one doesn't need to vary about anything)
def noadd_random_noise(prompt, noise_level=0.00):
    if noise_level == 0:
       noise_level = 0.00
    percentage_noise = noise_level * 5
    num_noise_chars = int(len(prompt) * (percentage_noise/100))
    noise_indices = random.sample(range(len(prompt)), num_noise_chars)
    prompt_list = list(prompt)
    noise_chars = list(string.ascii_letters + string.punctuation + '' + string.digits)
    noise_chars.extend([''])
    for index in noise_indices:
        prompt_list[index] = random.choice(noise_chars)
    return "".join(prompt_list)

#normal behavior
def add_random_noise(prompt, noise_level=0.00):
    if noise_level == 0:
        noise_level = 0.00
    percentage_noise = noise_level * 5
    num_noise_chars = int(len(prompt) * (percentage_noise/100))
    noise_indices = random.sample(range(len(prompt)), num_noise_chars)
    prompt_list = list(prompt)
    noise_chars = list(string.ascii_letters + string.punctuation + ' ' + string.digits)
    noise_chars.extend(['😍', 'beautiful', '😂', '🤔', '😊', '🤗', '😭', '🙄', 'pretty', '🤯', '🤫', '🥴', 'sitting', '🤩', '🥳', '😔', '😩', '🤪', '😇', 'retro', '😈', '👹', 'masterpiece', '🤖', '👽', 'high quality', '🎃', '🎅', '🎄', '🎁', '🎂', '🎉', '🎈', '🎊', '🎮', '❤️', '💔', '💕', '💖', '💗', '🐶', '🐱', 'visible', '🐹', '🦊', '🐻', '🐨', '🐯', '🦁', '🐘', '🔥', '🌧️', '🌞', '🌈', '💥', '🌴', '🌊', '🌺', '🌻', '🌸', '🎨', '🌅', '🌌', '☁️', '⛈️', '❄️', '☀️', '🌤️', '⛅️', '🌥️', '🌦️', '🌧️', '🌩️', '🌨️', '🌫️', '☔️', '🌬️', '💨', '🌪️', 'cute', 'kawaii', 'little', 'photo', 'movie', 'still'])
    for index in noise_indices:
        prompt_list[index] = random.choice(noise_chars)
    return "".join(prompt_list)

def send_it1(inputs, noise_level, proc1=proc1):
    prompt_with_noise = noadd_random_noise(inputs, noise_level)
    while queue.qsize() >= queue_threshold:
        time.sleep(2)
    queue.put(prompt_with_noise)
    output1 = proc1(prompt_with_noise)
    return output1

def send_it2(inputs, noise_level, proc1=proc1):
    prompt_with_noise = add_random_noise(inputs, noise_level)
    while queue.qsize() >= queue_threshold:
        time.sleep(2)
    queue.put(prompt_with_noise)
    output2 = proc1(prompt_with_noise)
    return output2

def send_it3(inputs, noise_level, proc1=proc1):
    prompt_with_noise = add_random_noise(inputs, noise_level)
    while queue.qsize() >= queue_threshold:
        time.sleep(2)
    queue.put(prompt_with_noise)
    output3 = proc1(prompt_with_noise)
    return output3

def send_it4(inputs, noise_level, proc1=proc1):
    prompt_with_noise = add_random_noise(inputs, noise_level)
    while queue.qsize() >= queue_threshold:
        time.sleep(2)
    queue.put(prompt_with_noise)
    output4 = proc1(prompt_with_noise)
    return output4

with gr.Blocks(css='style.css') as demo:
    gr.HTML(
        """
            <div style="text-align: center; max-width: 800px; margin: 0 auto;">
              <div>
                <style>
                    h1 {
                    font-size: 4em;
                    color: #ffffff;
                    margin-top: 20px;
                    margin-bottom: 20px;
                    text-shadow: 3px 3px 0 rgba(0, 0, 0, 1) !important;
                   }
                </style>
                <body>
                <div class="center"><h1>ImMagician</h1>
                </div>
                </body>
              </div>
              <p style="margin-bottom: 10px; color: #ffaa66; font-size: 98%">
              🤗 Celebrating 10000 views at blogger! 🤗</p>
              <p style="margin-bottom: 10px; color: #ffaa66; font-size: 98%">
              ❤️ Made by Achyuth! ❤️</a>
              </p>
            </div>
        """
    )  
    with gr.Column(elem_id="col-container"):
        with gr.Row(variant="compact"):
            input_text = gr.Textbox(
                label="Short Prompt",
                show_label=False,
                max_lines=20,
                placeholder="Enter a basic idea and click 'Magic Prompt'. Got no ideas? No problem, Simply just hit the magic button!",
            ).style(
                container=False,min_width=1200
            )
            see_prompts = gr.Button("✨Magic✨ ✨Prompt✨").style(full_width=False)

        
        with gr.Row(variant="compact"):
            prompt = gr.Textbox(
                label="Enter your prompt",
                show_label=False,
                max_lines=20,
                placeholder="Full Prompt",
            ).style(
                container=False,
            )
            run = gr.Button("Generate Images").style(full_width=False)
        with gr.Row():
            with gr.Row():
                #Now that the first box generates a picture with noise=0 having the default at 0 makes no sense as it'd generate the same image 6 times.
                noise_level = gr.Slider(minimum=0.5, maximum=3, step=0.1, label="Noise Level (0.1 or less was generating the same pic 6 times! 🤣)")
        gr.HTML(
        """
            <div style="text-align: center; max-width: 1200px; margin: 0 auto;">
              <div>
                <body>
                <div class="center"><p style="margin-bottom: 10px; color: #ffffff;">Please allow up to 1 minute for each image to generate, for a total of 6 minutes max.</p>
                </div>
                </body>
              </div>
            </div>
        """
               )
        with gr.Row():
            with gr.Row():
                output1=gr.Image(label="ImMagician", show_label=False, min_width=640, object_fit="contain", height="auto", download=True)
                output2=gr.Image(label="ImMagician", show_label=False, min_width=640, object_fit="contain", height="auto", download=True)
        with gr.Row():
            with gr.Row():
                output3=gr.Image(label="ImMagician", show_label=False, min_width=640, object_fit="contain", height="auto", download=True)
                output4=gr.Image(label="ImMagician", show_label=False, min_width=640, object_fit="contain", height="auto", download=True)
                
        see_prompts.click(get_prompts, inputs=[input_text], outputs=[prompt], queue=False)
        run.click(send_it1, inputs=[prompt, noise_level], outputs=[output1])
        run.click(send_it2, inputs=[prompt, noise_level], outputs=[output2])
        run.click(send_it3, inputs=[prompt, noise_level], outputs=[output3])
        run.click(send_it4, inputs=[prompt, noise_level], outputs=[output4])

        with gr.Row():
                gr.HTML(
    """
        <div class="footer">
        <p> Demo for <a href="https://huggingface.co/AchyuthGamer/ImMagician">ImMagician🪄</a> Stable Diffusion model
</p>
</div>
        <div class="acknowledgments" style="font-size: 115%; color: #ffffff;">
            <p> Unleash your creative side and generate mesmerizing images with just a few clicks! Enter a spark of inspiration in the "Basic Idea" text box and click the "Magic Prompt" button to elevate it to a polished masterpiece. Make any final tweaks in the "Full Prompt" box and hit the "Generate Images" button to watch your vision come to life. Experiment with the "Noise Level" for a diverse range of outputs, from similar to wildly unique. Let the fun begin!
            </p>
        </div>
    """
)

    demo.launch(enable_queue=True, inline=True)
    block.queue(concurrency_count=50)