from transformers import GPT2LMHeadModel, GPT2Tokenizer

tokenizer = GPT2Tokenizer.from_pretrained("gpt2-large")
model = GPT2LMHeadModel.from_pretrained("gpt2-large", pad_token_id=tokenizer.eos_token_id)

from transformers import pipeline, set_seed
generator = pipeline('text-generation', model='gpt2')

def generate_text(prompt):
    text1 = generator(prompt, max_length=3000, num_return_sequences=1)
    return text1[0].get('generated_text')
    
    
import gradio as gr

gr.Interface(
    title = 'Text Generation using GPT 2', 
    fn=generate_text, 
    inputs=gr.Textbox(placeholder="Type Here..."),
    outputs=[
        "text"
    ],
    theme = 'darkhuggingface').launch()