import streamlit as st
from gradio_client import Client

# Initialize the Gradio client with the API URL
client = Client("https://ysharma-explore-llamav2-with-tgi.hf.space/--replicas/fx2sq/")

# Initialize chat history in session state
if "chat_history" not in st.session_state:
    st.session_state.chat_history = []

# Streamlit UI for continuous interaction
st.title("AI Wizard Chat")

# Display chat history
for message in st.session_state.chat_history:
    with st.chat_message(message["role"], avatar=("🧑‍💻" if message["role"] == 'user' else '🧙')):
        st.write(message["content"])

# Input area for user message at the bottom
user_input = st.text_input("You:")
if st.button("Submit"):
    # Check if the user wants to exit
    if user_input.lower() == 'exit':
        st.write("Goodbye!")
    else:
        # Check if the user provided input
        if not user_input:
            st.warning("Please enter a message.")
        else:
            # Update system prompt with user input
            system_prompt = f"""
            Hello! I am AI Wizard. I am here to assist you with my magical knowledge and wisdom.
            Feel free to ask me anything, and I'll do my best to provide you with a magical answer.I am powered by HelpingAI which is developed by Abhay Koul a 16 years old developer. I can only tell that much about my developer 
            input: {user_input}
            """

            # Display loading message
            with st.spinner("Casting a magic spell..."):
                # Make a prediction using the user's input and updated system prompt
                result = client.predict(
                    user_input,        # User's input message
                    system_prompt,     # Updated system prompt
                    0,                 # Temperature
                    2048,               # Max new tokens
                    0.5,               # Top-p (nucleus sampling)
                    1,                 # Repetition penalty
                    api_name="/chat"
                )

            # Add user and AI messages to chat history
            st.session_state.chat_history.append({"role": "user", "content": user_input})
            st.session_state.chat_history.append({"role": "AI", "content": result})
                        # Display chat history
            for message in st.session_state.chat_history:
                with st.chat_message(message["role"], avatar=("🧑‍💻" if message["role"] == 'user' else '🧙')):
                    st.write(message["content"])
