import streamlit as st
import requests
import google.generativeai as palm

# Set the page title and icon
st.set_page_config(page_title="Wikipedia Microbot and AI Mode")

# Wikipedia Microbot Constants
WIKIPEDIA_API_URL = "https://en.wikipedia.org/w/api.php"

# AI Mode Constants
palm.configure(api_key="AIzaSyCnrcQWTEedcGuEsJ9Uhbj_ZS9B2nozMiU")
defaults = {
    'model': 'models/text-bison-001',
    'temperature': 1,
    'candidate_count': 1,
    'top_k': 40,
    'top_p': 0.95,
    'max_output_tokens': 1024,
    'stop_sequences': [],
    'safety_settings': [
        {"category": "HARM_CATEGORY_DEROGATORY", "threshold": 4},
        {"category": "HARM_CATEGORY_TOXICITY", "threshold": 4},
        {"category": "HARM_CATEGORY_VIOLENCE", "threshold": 4},
        {"category": "HARM_CATEGORY_SEXUAL", "threshold": 4},
        {"category": "HARM_CATEGORY_MEDICAL", "threshold": 4},
        {"category": "HARM_CATEGORY_DANGEROUS", "threshold": 4},
    ]
}

# Custom Instruction
custom_instruction = """
I am a small system from HelpingAI made by Abhay Koul who is 16 years old and lives in KP Colony, Vessu, Anantnag. Abhay Koul is currently working on more AI and AI-related projects.Certainly! If you're looking for more information about Abhay Koul's projects and HelpingAI, I would recommend joining the Discord community. You can find additional details there. He has been working on AI from Jan 2023. If you want more details, you can join the Discord community. The main function of HelpingAI is to make learning and education easier and more convenient for students. My purpose is to simplify your learning journey by providing personalized assistance, innovative teaching methods, and tailored resources to meet your unique needs. I am here to make your educational experience more enjoyable and effective. Feel free to ask me any questions or let me know how I can assist you in your learning adventure and in many more things from your life.
"""

# Create tabs for Wikipedia Microbot and AI Mode
selected_mode = st.radio("Select Mode", ["Wikipedia Microbot", "AI Mode"])

if selected_mode == "Wikipedia Microbot":
    # Wikipedia Microbot Code
    st.title("Wikipedia Microbot")
    st.markdown("Explore Wikipedia with Ease")

    # Sidebar for user options
    st.sidebar.header("Options")

    # User input and search button
    query = st.sidebar.text_input("Enter a Query", help="E.g., 'Python programming'")
    search_button = st.sidebar.button("Search")

    # Container for main content
    main_container = st.container()

    if search_button:
        if query:
            try:
                # Search Wikipedia for the query
                params = {
                    "action": "query",
                    "format": "json",
                    "prop": "extracts|info|pageviews",
                    "exintro": True,
                    "explaintext": True,
                    "exsectionformat": "plain",
                    "titles": query,
                    "utf8": 1,
                    "formatversion": 2,
                    "pvipdays": 7,
                }

                response = requests.get(WIKIPEDIA_API_URL, params=params)

                if response.status_code == 200:
                    data = response.json()

                    if "error" in data:
                        st.sidebar.error(f"Error: {data['error']['info']}")
                    else:
                        page = data["query"]["pages"][0]

                        # Display page title
                        st.title(page['title'])

                        # Display page views statistics
                        views = page.get("pageviews", {}).get(query, "Data not available")
                        st.info(f"Page Views (Last 7 days): {views}")

                        # Display summary
                        st.write(page.get("extract", "No summary available."))

                else:
                    st.sidebar.error("Error: Unable to retrieve data from Wikipedia. Please try again later.")
            except Exception as e:
                st.sidebar.error(f"Error: {e}")

elif selected_mode == "AI Mode":
    # AI Mode Code
    st.title("AI Mode")
    st.markdown("Interact with an AI powered by Abhay Koul")

    user_input = st.text_area('You:', height=100, help="Type your message here")

    if st.button('Submit', key='ai_button'):
        with st.spinner("Thinking..."):
            if user_input.lower() in ['quit', 'exit', 'bye']:
                st.write("Goodbye! Have a great day!")
            else:
                # Create a chat history session state
                session_state = st.session_state.get(user_input, [])
                session_state.append({"user": user_input})
                st.session_state[user_input] = session_state

                # Prepare conversation history
                conversation_history = "\n".join(["You: " + item["user"] for item in session_state])

                # Construct the prompt with conversation history
                prompt = f"""{custom_instruction}
Your conversation history:\n{conversation_history}
Your AI-generated response:"""

                response = palm.generate_text(**defaults, prompt=prompt)
                st.write(response.result)
