import streamlit as st
import requests
from bs4 import BeautifulSoup

st.set_page_config(page_title="Word Definition App")

def fetch_definition(word):
    base_url = f"https://www.merriam-webster.com/dictionary/{word}"

    response = requests.get(base_url)

    if response.status_code == 200:
        soup = BeautifulSoup(response.text, 'html.parser')
        definition_span = soup.find("span", class_="dtText")

        if definition_span:
            full_definition = definition_span.get_text()
            sentences = full_definition.split('. ')
            limited_definition = '. '.join(sentences[:3])
            return limited_definition
        else:
            return "Definition not found."
    else:
        return "Word not found or unable to retrieve data."

def main():
    st.title("Word Definition App")
    word = st.text_input("Enter a word:")

    if word.lower() == 'quit':
        st.warning("You entered 'quit'. The app will not quit as this is a web application.")
    else:
        if st.button("Get Definition"):
            definition = fetch_definition(word)
            st.write("Definition:")
            st.write(definition)

if __name__ == '__main__':
    main()
