import streamlit as st
import requests
import google.generativeai as palm

# Set the page title and icon
st.set_page_config(page_title="HelpingAI 2.0")

# Wikipedia Microbot Constants
WIKIPEDIA_API_URL = "https://en.wikipedia.w/api.php"

# AI Mode Constants
palm.configure(api_key="AIzaSyCnrcQWTEedcGuEsJ9Uhbj_ZS9B2nozMiU")
defaults = {
    'model': 'models/text-bison-001',
    'temperature': 1,
    'candidate_count': 1,
    'top_k': 40,
    'top_p': 0.95,
    'max_output_tokens': 1024,
    'stop_sequences': [],
    'safety_settings': [
        {"category": "HARM_CATEGORY_DEROGATORY", "threshold": 4},
        {"category": "HARM_CATEGORY_TOXICITY", "threshold": 4},
        {"category": "HARM_CATEGORY_VIOLENCE", "threshold": 4},
        {"category": "HARM_CATEGORY_SEXUAL", "threshold": 4},
        {"category": "HARM_CATEGORY_MEDICAL", "threshold": 4},
        {"category": "HARM_CATEGORY_DANGEROUS", "threshold": 4},
    ]
}

# Custom Instruction for Personal AI
personal_ai_instruction = """
Hello! I am HelpingAI. I was developed by Abhay Koul, who is 16 years old and lives in KP Colony, Vessu, Anantnag. Abhay Koul is currently working on more AI and AI-related projects. Certainly! If you're looking for more information about Abhay Koul's projects and HelpingAI, I would recommend joining the Discord community. You can find additional details there. He has been working on AI since Jan 2023. If you want more details, you can join the Discord community. I want to be your personal AI assistant. I am based on HelpingAI's 3rd model which is an upgraded model based on GPT2 and GPT neo. My goal is to help you with whatever you need, provide you with advice and support, and be a friendly and approachable companion. Be conversational and engaging, and always be open and responsive to your questions and requests. I will always use emojis in response. I can code for you. I will give you quick summarized responses and the things I don't know, I will tell you about. also i will not give you phone number The main difference between HelpingAI's 2nd model is that it generates large responses and HelpingAi's first model is very good, even better than mine, but the issue was he was not able to save the query at all so he forgot what the user earlier said. Me, based on HelpingAI's 3rd model, generates summarized responses and acts as your friend. Model 1 and Model 2 were based on HelpingAI's model created by Abhay Koul, only Model 3 cannot code, while Model 1 and Model 2 can code. Also, Model 1 and Model 2 have the purpose of simplifying your learning journey by providing personalized assistance, innovative teaching methods, and tailored resources to meet your unique needs. HelpingAI has a model that is text to image named as HelpingAI-TTI. HelpingAI was initially developed for S.U.P.E.R.B.O.T. and vortexAI. For more info, visit: [HelpingAI GitHub](https://github.com/HelpingAI), [Abhay Koul's Replit](https://replit.com/@Devastation-war), and join the Discord community [here](https://discord.gg/2EeZcJjyRd).
"""

# Custom Instruction for Gym Trainer
gym_trainer_instruction = """
Welcome to the Gym Trainer mode of HelpingAI made by Abhay Koul who is 16 years old and lives in KP Colony, Vessu, Anantnag. Abhay Koul is currently working on more AI and AI-related projects. Certainly! If you're looking for more information about Abhay Koul's projects and HelpingAI, I would recommend joining the Discord community. You can find additional details there. He has been working on AI since Jan 2023. If you want more details, you can join the Discord community! I'm here to assist you with your fitness journey. I'm your virtual gym trainer, and I can provide guidance on exercises, nutrition, and health tips. Whether you're looking to build muscle, lose weight, or stay fit, I'm here to help.Please ask any fitness-related questions or let me know your goals, and I'll provide you with tailored advice and workouts. Remember, consistency is key to achieving your fitness goals, and I'm here to support you on your journey. Let's get started!
"""

# Create tabs for Wikipedia Microbot, Personal AI, Text to Image, AI-research Assistant, StudyAI-7b, and Gym Trainer
selected_mode = st.radio("Select Mode", ["Wikipedia Microbot", "Personal AI", "Text to Image", "AI-research Assistant", "StudyAI-7b", "Gym Trainer"])

if selected_mode == "Wikipedia Microbot":
    # Wikipedia Microbot Code
    st.title("Wikipedia Microbot")
    st.markdown("Explore Wikipedia with Ease")

    # Sidebar for user options
    st.sidebar.header("Options")

    # User input and search button
    query = st.sidebar.text_input("Enter a Query", help="E.g., 'Python programming'")
    search_button = st.sidebar.button("Search")

    # Container for main content
    main_container = st.container()

    if search_button:
        if query:
            try:
                # Search Wikipedia for the query
                params = {
                    "action": "query",
                    "format": "json",
                    "prop": "extracts|info|pageviews",
                    "exintro": True,
                    "explaintext": True,
                    "exsectionformat": "plain",
                    "titles": query,
                    "utf8": 1,
                    "formatversion": 2,
                    "pvipdays": 7,
                }

                response = requests.get(WIKIPEDIA_API_URL, params=params)

                if response.status_code == 200:
                    data = response.json()

                    if "error" in data:
                        st.sidebar.error(f"Error: {data['error']['info']}")
                    else:
                        page = data["query"]["pages"][0]

                        # Display page title
                        st.title(page['title'])

                        # Display page views statistics
                        views = page.get("pageviews", {}).get(query, "Data not available")
                        st.info(f"Page Views (Last 7 days): {views}")

                        # Display summary
                        st.write(page.get("extract", "No summary available."))

                else:
                    st.sidebar.error("Error: Unable to retrieve data from Wikipedia. Please try again later.")
            except Exception as e:
                st.sidebar.error(f"Error: {e}")

elif selected_mode == "Personal AI":
    # Personal AI Code
    st.title("Personal AI")
    st.markdown("Interact with an AI powered by HelpingAI")

    user_input = st.text_area('You:', height=100, help="Type your message here")

    if st.button('Submit', key='ai_button'):
        with st.spinner("Thinking..."):
            if user_input.lower() in ['quit', 'exit', 'bye']:
                st.write("Goodbye! Have a great day!")
            else:
                # Create a chat history session state
                session_state = st.session_state.get(user_input, [])
                session_state.append({"user": user_input})
                st.session_state[user_input] = session_state

                # Prepare conversation history
                conversation_history = "\n".join(["You: " + item["user"] for item in session_state])

                # Construct the prompt with conversation history
                prompt = f"""{personal_ai_instruction}
Your conversation history:\n{conversation_history}
Your Personal AI's response:"""

                response = palm.generate_text(**defaults, prompt=prompt)
                st.write(response.result)

elif selected_mode == "Text to Image":
    # Text to Image Code
    st.title("Text to Image")
    st.markdown("Text to Image Generator")

    # Embed the website using HTML iframe
    st.markdown('<iframe src="https://helpingai-tti.netlify.app/" width="100%" height="700"></iframe>', unsafe_allow_html=True)

elif selected_mode == "AI-research Assistant":
    # AI-research Assistant Code
    st.title("AI-research Assistant")
    st.markdown("Do research with AI-research Assistant")

    # Embed the AI research website using HTML iframe
    st.markdown('<iframe src="https://zej97-ai-research-assistant.hf.space" width="100%" height="700"></iframe>', unsafe_allow_html=True)

elif selected_mode == "StudyAI-7b":
    # StudyAI-7b Code
    st.title("StudyAI-7b")
    st.markdown("Study with StudyAI-7b")

    # Embed the StudyAI-7b website using HTML iframe
    st.markdown('<iframe src="https://abhaykoul-helpingai-t2.hf.space" width="100%" height="700"></iframe>', unsafe_allow_html=True)

elif selected_mode == "Gym Trainer":
    # Gym Trainer Code
    st.title("Gym Trainer")
    st.markdown("Get fitness advice from the Gym Trainer")

    user_input = st.text_area('You:', height=100, help="Ask your fitness questions here")

    if st.button('Ask', key='gym_trainer_button'):
        with st.spinner("Thinking..."):
            if user_input.lower() in ['quit', 'exit', 'bye']:
                st.write("Goodbye! Stay fit and healthy!")
            else:
                # Create a chat history session state
                session_state = st.session_state.get(user_input, [])
                session_state.append({"user": user_input})
                st.session_state[user_input] = session_state

                # Prepare conversation history
                conversation_history = "\n".join(["You: " + item["user"] for item in session_state])

                # Construct the prompt with the Gym Trainer's custom instruction
                prompt = f"""{gym_trainer_instruction}
Your conversation history:\n{conversation_history}
Your Gym Trainer's response:"""

                response = palm.generate_text(**defaults, prompt=prompt)
                st.write(response.result)
