from bardapi import BardCookies
import requests
from requests.exceptions import ReadTimeout
import gradio as gr

def get_bard_response(Secure_1PSID, Secure_1PSIDTS, Secure_1PSIDCC, Query):
    cookie_dict = {
        "__Secure-1PSID": Secure_1PSID,
        "__Secure-1PSIDTS": Secure_1PSIDTS,
        "__Secure-1PSIDCC": Secure_1PSIDCC
    }

    bard = BardCookies(cookie_dict=cookie_dict)
    retries = 3  # Number of retries
    for _ in range(retries):
        try:
            Reply = bard.get_answer(Query)['content']
            return Reply
        except ReadTimeout:
            continue
    return "Failed to fetch data after multiple retries."

iface = gr.Interface(
    fn=get_bard_response,
    inputs=[
        gr.components.Textbox(label="__Secure-1PSID"),
        gr.components.Textbox(label="__Secure-1PSIDTS"),
        gr.components.Textbox(label="__Secure-1PSIDCC"),
        gr.components.Textbox(label="Query")
    ],
    outputs="text",
    title="BardCookies - AI Query",
    description = "Enter your cookies and a query to get a response from BardCookies. If you need help with cookies, check out the <a href='https://chrome.google.com/webstore/detail/editthiscookie/fngmhnnpilhplaeedifhccceomclgfbg?utm_source=ext_app_menu' target='_blank'>Chrome extension</a> for managing cookies. Go to bard.google.com and then use EditThisCookie extension and copy Secure_1PSID, Secure_1PSIDTS, Secure_1PSIDCC from it. <a href='https://bard.google.com/chat' target='_blank'>Bard Chat</a>."
)

iface.launch()