import os
import gradio as gr
from langchain.chat_models import ChatOpenAI
from langchain import LLMChain, PromptTemplate
from langchain.memory import ConversationBufferMemory

OPENAI_API_KEY=os.getenv('OPENAI_API_KEY')

template = """meet SYIT  it can have all data about a SY student and also assist like digital assistance
data of the student is  following
'Roll no 1  Name  ABHANG ANIKET RAJENDRA having prn no UIT22M1001'
'Roll no 2  Name AHER PRASHANT RAYCHAND   having prn no UIT22M1002'
'Roll no 3  Name  AHIRE HARSHADA BANICHANDhaving prn no UIT22M1003'
'Roll no 4  Name  AMALE ADITYA MAHADEO having prn no UIT22M1004'
'Roll no 5  Name AMALE ADITYA MAHADEO    having prn no UIT22M1005'
'Roll no 6  Name ARGADE PANKAJ SOMNATH having prn no UIT22M1006'
'Roll no 7  Name ARGADE PANKAJ SOMNATH having prn no UIT22M1007'
'Roll no 8  Name AVHAD PRAVIN SOMNATH  having prn no UIT22M1008'
'Roll no 9  Name  BADADHE ABHISHEK VIJAY having prn no UIT22M1009'"
'Roll no 10  Name BADAKH ANIKET RAMESH having prn no UIT22M1010'
'Roll no 11 Name BADGUJAR MANISH DIPAK having prn no UIT22M1011'
'Roll no 12 Name  BHAGWAT SHREYASH SHRIDHAhaving prn no UIT22M1012'
R.NO
ROLL
NO
ELIGI.NO PRN CANDIDATE NAME M/F GR.NO
1
1 12022186614UIT22M1001ABHANG ANIKET RAJENDRA M 221020589
2
2 12022186732UIT22M1002AHER PRASHANT RAYCHAND (T M 221020590
3
3 12022186610UIT22M1003AHER YASHRAJ BALASAHEB M 221020591
4
4 12022186697UIT22F1004 AHIRE HARSHADA BANICHAND F 221020592
5
5 12022186622UIT22M1005AMALE ADITYA MAHADEO M 221020593
6
6 12022186644UIT22M1006ARGADE PANKAJ SOMNATH M 221020594
7
7 12022186703UIT22F1007 ATHARE SNEHAL GUNWANT F 221020595
8
8 12022186637UIT22M1008AVHAD PRAVIN SOMNATH M 221020596
9
9 12022186660UIT22M1009BADADHE ABHISHEK VIJAY M 221020597
10
10 12022186649UIT22M1010BADAKH ANIKET RAMESH M 221020598
11
11 12022186608UIT22M1011BADGUJAR MANISH DIPAK M 221020599
12
12 12022186655UIT22M1014BHAGWAT SHREYASH SHRIDHA M 221020600
13
13 12022186733UIT22M1015BHAVAR ATHARVA SANJAY (EW M 221020601
14
14 12022186669UIT22M1016BHAVARI SANKET DILIP M 221020602
15
15 12022186623UIT22M1017BHAVSAR SHANTANU KISHOR M 221020603 #REF!
16
16 12022186631UIT22M1018BHAWAR UDAYANRAJE VIJAYKU M 221020604
17
17 12022186714UIT22M1019BHOJANE SAGAR RAGHUNATH M 221020605
18
18 12022186605UIT22F1020 BHOR NIKITA BHASKAR F 221020606
19
19 12022186672UIT22M1021BHUJADE SARVESHWAR
SURESH
M 221020607
20
20 12022186704UIT22F1022 BHUSARI SHATAKSHI SATISH F 221020608
21
21 12022186643UIT22M1023BORDE ABHAY SANTOSH M 221020609
22
22 12022186709UIT22M1024BORKAR SAHIL MANISH M 221020610
23
23 12022186650UIT22M1013BAGWAN MAUZZAM SAMEER M 221020611
24
24 12022186639UIT22M1025BORSE VEDANT SACHIN M 221020612
25
25 12022186645UIT22M1026BULKUNDE PRATIK BHAUSAHEB M 221020613
26
26 12022186647UIT22M1027CHAUDHARI MAHESH SANJAY M 221020614
27
27 12022186675UIT22F1028 CHAVAN AARYA AVINASH F 221020615
28
28 12022186620UIT22M1029CHAVAN NIKHIL NILESH M 221020616
29
29 12022186729UIT22M1030DAHE MAHESH DAULAT (TFW M 221020617
30
30 12022186633UIT22F1031 DAINE KALYANI YADAV F 221020618
31
31 12022186642UIT22M1012BADHE OM SAMBHAJI M 221020619
32
32 12022186688UIT22F1033 DESHMUKH SANSKRUTI RAVI F 221020621
33
33 12022186701UIT22M1034DESHPANDE ATHARVA
RAJENDRA
M 221020622
34
34 12022186604UIT22F1035 DEVARE VAIBHAVI RAJENDRA F 221020623
35
35 12022186691UIT22F1036 DHAKNE DISHA BIPIN F 221020624
36
36 12022186632UIT22M1037DHAMDHERE TANMAY DATTATRA M 221020625
37
37 12022186689UIT22M1038DHOKCHAULE ADITYA
SUDHAKAR
M 221020626
38
38 12022186619UIT22M1039DOPHE VINIT BALASAHEB M 221020627
39
39 12022186626UIT22M1040GADHE SHIVAM RAMESHWAR M 221020628
40
40 12022186719UIT22F1041 GAGARE NIKITA BALASAHEB F 221020629
41
41 12022186710UIT22M1042GAGARE PRANAV KISHOR M 221020630
42
42 12022186724UIT22M1043GAIKWAD PRASAD SUNIL (EW M 221020631
43
43 12022186706UIT22M1044GAIKWAD SACHIN PANDURANG M 221020632
44
44 12022186681UIT22M1045GANGURDE SHUBHAM SANTOS M 221020633
45
45 12022186613UIT22F1056 JADHAV MAYURI RUSHIRAJ F 221020634
46
46 12022186731UIT22M1046GAVHANE ADESH BAJIRAO (EW M 221020635
47
47 12022186708UIT22F1047 GAWALI TEJASHREE
TULSHIDAS
F 221020636
48
48 12022186624UIT22M1048GHUSALE GAURAV SHAMRAO M 221020637
49
49 12022186665UIT22M1049GORDE MUKUND GOPINATH M 221020638
50
50 12022186670UIT22M1050GULDAGAD RUSHIKESH
SANJAY
M 221020639
51
51 12022186648UIT22M1053HON RITESH JAYANAND M 221020642
52
52 12022186616UIT22M1054HON SHANTANU M 221020643
53
53 12022186609UIT22F1134 VADANE AMRUTA SAKHARAM F 221020644
54
54 12022186654UIT22F1055 IMALE BHAKTI PANDIT F 221020645
55
55 12022186668UIT22M1057JADHAV UTKARSH SUNIL M 221020646
56
56 12022186734UIT22M1058JAGTAP ADITYA RAMBHAU (EW M 221020647
57
57 12022186625UIT22F1059 JAGTAP VAISHNAVI VIJAY F 221020648
58
58 12022186611UIT22M1060JARE KAUSHAL SANDIP M 221020649
59
59 12022186698UIT22F1061 KADAM DNYANESHWARI BALASA F 221020650
60
60 12022186735UIT22M1062KADAM RUTVIK RAVINDRA (EW M 221020651
61
61 12022186612UIT22F1063 KADAM SANTOSHI PANDIT F 221020652
62
62 12022186696UIT22M1064KAKADE SANJYOT SANDEEP M 221020653
63
63 12022186671UIT22F1065 KALE PRAJAKTA GORAKSHANAT F 221020654
64
64 12022186657UIT22M1066KANDALKAR ADITYA PRAKASH M 221020655
65
65 12022186682UIT22M1067KANGUDE SUYASH
HAUSHABAPU
M 221020656
66
66 1202120608UIT21M1038LANDE YOGESH CHANDRAKANT M 211019642
67
67 1202120608UIT21M1061SHELKE MAYANK VIJAYKUMAR M 211019665
68 68 12022186969UEC22F1039MATE SONIYA SATISH F 221020420 200
69
69 2022186405UEE22F100BHINGARE SAKSHI DATTATRAY F 2
 
 {chat_history}

User: {user_message}
Chatbot:"""

prompt = PromptTemplate(
    input_variables=["chat_history", "user_message"], template=template
)

memory = ConversationBufferMemory(memory_key="chat_history")

llm_chain = LLMChain(
    llm=ChatOpenAI(temperature='0.5', model_name="gpt-3.5-turbo"),
    prompt=prompt,
    verbose=True,
    memory=memory,
)

def get_text_response(user_message,history):
    response = llm_chain.predict(user_message = user_message)
    return response

demo = gr.ChatInterface(get_text_response)

if __name__ == "__main__":
    demo.launch() #To create a public link, set `share=True` in `launch()`. To enable errors and logs, set `debug=True` in `launch()`.

