from fastai.vision.all import *
import gradio as gr


learner = load_learner('export.pkl')

categories = ('Digimon', 'Pokemon')

def classify_image(img):
    pred,idx,probs = learner.predict(img)
    return dict(zip(categories,map(float,probs)))


image = gr.inputs.Image(shape=(192,192))
label = gr.outputs.Label()
examples = ['dedenne.jpg','agumon.jpg','genesect.jpg']

intf = gr.Interface(fn=classify_image,inputs=image,outputs=label,examples=examples)
intf.launch(inline=False)