import gradio as gr
import numpy as np
import tensorflow as tf 
import keras 

from keras.models import load_model
from keras.preprocessing import image

cnn_model = keras.models.load_model("fine_tuning.keras")

def detect(img):
    img = img.reshape(-1,180,180,3)
    prediction = np.around(cnn_model.predict(img)[0], decimals=0)[0]

    if prediction == 1:
        return "Pneumonia Detected!"

    return "Pneumonia Not Detected!"

#set the user uploaded image as the input array
#match same shape as the input shape in the model

image_input = gr.inputs.Image( shape=(180, 180) ,invert_colors=False  ,   type="numpy"    )

title = "PneumoDetect: Pneumonia Detection from Chest X-Rays"


#setup the interface
iface = gr.Interface(
  fn = detect,
  inputs = image_input,
  outputs = gr.outputs.Label(),
)
iface.launch(share=True , debug = True )