import gradio as gr
from fastai.vision.all import *
from PIL import Image
import tempfile
import os

import rarfile
import librosa
import librosa.display
import matplotlib.pyplot as plt

# Chargez votre modèle Fastai 
learn = load_learner('woodsound')

# Fonction pour effectuer la prédiction à partir d'un fichier audio
def predict_audio(audio_file):

    # Charger le fichier audio
    samples, sample_rate = librosa.load(audio_file)

    # Créez un répertoire temporaire pour stocker l'image temporaire
    with tempfile.TemporaryDirectory() as temp_dir:

        # Créer le nom de fichier pour le spectrogramme
        spectrogram_filename = os.path.splitext(os.path.basename(audio_file))[0] + ".png"
        temp_image_path = os.path.join(temp_dir, spectrogram_filename)

        # Créer et enregistrer le spectrogramme
        plt.figure(figsize=(0.72, 0.72))
        ax = plt.subplot(111)
        ax.axes.get_xaxis().set_visible(False)
        ax.axes.get_yaxis().set_visible(False)
        ax.set_frame_on(False)
        S = librosa.feature.melspectrogram(y=samples, sr=sample_rate)
        librosa.display.specshow(librosa.power_to_db(S, ref=np.max))
        plt.savefig(temp_image_path, dpi=400, bbox_inches='tight', pad_inches=0)
        plt.close()

        # Effectuez la prédiction avec le modèle en utilisant l'image temporaire
        probabilities = predict_with_probabilities(temp_image_path, learn)

    return probabilities



# Fonction pour effectuer la prédiction avec le modèle Fastai
def predict_with_probabilities(image_path, learn):

    # Chargez l'image
    img = Image.open(image_path).convert('RGB')

    # Redimensionnez l'image à 224x224
    img = img.resize((224, 224))

    # Convertissez l'image en un format que Fastai peut utiliser (PILImage)
    img = PILImage(img)

    # Faites la prédiction sur l'image redimensionnée
    pred,idx,prob = learn.predict(img)

    # Obtenez les noms des catégories
    categories = ('ache', 'scie_electrique', 'oiseaux', 'arme_a_feu', 'scie_manuelle')

    return dict(zip(categories,map(float,prob)))

# Créez l'interface Gradio
examples_files = [
    ["song_1.wav"],
    ["song_2.mp3"],
]
audio_input = gr.Audio(source='upload', type='filepath', label="Sélectionnez un fichier audio (wav, mp3, etc.)", )
output_component = gr.Label(num_top_classes= 5)
gr.Interface(fn=predict_audio, inputs=audio_input, outputs=output_component, examples=examples_files).launch(share=True)
