import gc 
import gradio as gr
from transformers import pipeline, set_seed

pipe = pipeline('text-generation', framework='pt', model='akhooli/ap2023', tokenizer='akhooli/ap2023')
#gc.collect()
samples = [['أنت'
           ,1.0, 50, 1.0, 1.0, 114],['هل غادر'
            ,1.0, 50, 1.0, 1.0, 114 ],['ألا ليت'
              ,1.0, 50, 1.0, 1.0, 114 ],['يا قدس'
                 ,1.0, 50, 1.0, 1.0, 114],['عيد بأية حال'
                   ,1.0, 50, 1.0, 1.0, 114],['لكل شيء إذا ما'
                    ,1.0, 50, 1.0, 1.0, 114 ],['.'
                       ,1.0, 50, 1.0, 1.0, 114]]
                     
notes = """
- Enter a short prompt or select (click) one of the examples and click SEND 
- Adjust parameters (temperture, top k, top p and penalty) through the slider (keep close to default values).
- For the same seed (randomness), the same output is regenerated if other parameters are fixed 
- Clear and enter new prompt or select another example and SEND to regenerate
- The '.' means start a new line from no prompt (your prompt need not be long) 
- Be patient: this runs on CPU (free tier)
- Feedback (Twitter): @akhooli (https://twitter.com/akhooli/status/1611025232201977859) 
- Note/Disclaimer: may generate unaccepted or inappropriate content. Use at your own risk.
"""
def sayPoetry(prompt, temp=1.0, topk = 50, topp = 1.0, penalty=1.0, seed=114):
    if not int(seed) >= 0: seed=114
    set_seed(seed)
    gen = pipe(prompt, max_length=96, do_sample=True, temperature=temp, top_k=topk, top_p=topp, repetition_penalty=penalty,
              min_length = 64, no_repeat_ngram_size = 3, return_full_text=True,
               num_beams=5, num_return_sequences=1)[0]["generated_text"]
    poetry =""
    for line in gen.split('.')[:-1]:
        poetry += line #+ "\n"
    return poetry
poetry = gr.Interface(fn=sayPoetry, 
                    inputs=[
                        gr.Textbox(label="Enter short prompt or select from examples:"), 
                        gr.Slider(0.70, 1.2, step=0.01,value=1.0, label='control  temperature'),
                        gr.Slider(25, 100, step=1,value=50, label='control  top k'),
                        gr.Slider(0.80, 1.0, step=0.01,value=1.0, label='control  top p'),
                        gr.Slider(0.90, 1.50, step=0.01,value=1.0, label='control  penalty'),
                        gr.Number(value=139750, precision=0, label='Seed'),
                    ], 
                outputs=[gr.Textbox(label="Generated Poetry:")], 
                    
                allow_flagging='never',
                title='Arabic Poetry Generation Demo (updated Jan. 2023)',
                description = "A simple demo of AI generated poetry based on 1M poems fine-tuned using AraGPT2 (be patient, runs on cpu)",
                examples=samples,
                cache_examples=False,
                article = notes)
poetry.launch() # show_error = True, debug=True