import gradio as gr

description = "التعرف على خاصيات البيت الشعري"
title = """هذا البرنامج يقوم بالتعرف على مختلف خاصيات البيت من الشعر.
يمكنكم إختيار الخاصية من بين:
- التعرف على البحر
- التعرف على الروي
التعرف على الموضوع-"""

examples = [["سَلو قَلبي غَداةَ سَلا وَثابا لَعَلَّ عَلى الجَمالِ لَهُ عِتابا"], ["قفا نبك من ذِكرى حبيب ومنزلِ بسِقطِ اللِّوى بينَ الدَّخول فحَوْملِ"]]


meter = gr.Interface.load("huggingface/Yah216/Arabic_poem_meter_3",
                        description="من فضلك، أدخل البيت الشعري الذي تود التعرف عليه",
                        examples=examples, title = "التعرف على البحر",
                          inputs = gr.inputs.Textbox(lines = 3, label = "البيت")

)
rawiy = gr.Interface.load("huggingface/Yah216/Poem_Qafiyah_Detection",
                         title ="التعرف على الروي",
                         examples=examples,
                         description="من فضلك، أدخل البيت الشعري الذي تود التعرف عليه",
                         inputs = gr.inputs.Textbox(lines = 3, label = "البيت")
 
)
subject = gr.Interface.load(
              "huggingface/zenkri/autotrain-Arabic_Poetry_by_Subject-920730230",
               title="التعرف على الموضوع",
               examples=examples,
               description="من فضلك، أدخل البيت الشعري الذي تود التعرف عليه",
                inputs = gr.inputs.Textbox(lines = 3, label = "البيت")

)
demo = gr.TabbedInterface([meter, rawiy, subject], ["التعرف على البحر","التعرف على الروي","التعرف على الموضوع"])
demo.launch()

