import openai
import speech_recognition as sr  
import gradio as gr

restaurants = {
    "Joe's Pizza": {
        "Margherita Pizza": 14.99,
        "Pepperoni Pizza": 16.99,
        "Vegetable Pizza": 15.99,
        "Caesar Salad": 8.99,
        "Garlic Knots": 5.99,
        "Diet Coke": 2.99,
        "Chocolate Chip Cookie": 2.99
    },
    "Bamboo House": {
        "Whopper Meal": 7.99,
        "Chicken Fries": 3.99,
        "Impossible Whopper": 5.99,
        "Chicken Sandwich": 4.99,
        "Onion Rings": 2.99,
        "Fountain Drink": 1.99,
        "Apple Pie": 1.49
    },
    "Taco Bell": {
        "Crunchwrap Supreme": 4.99,
        "Beef Quesarito": 3.99,
        "Nachos Supreme": 2.99,
        "Cheesy Gordita Crunch": 4.99,
        "Soft Taco": 1.29,
        "Baja Blast Freeze": 2.49,
        "Cinnamon Twists": 1.99
    },
    "Curry Kingdom": {
        "Big Mac-Meal": 6.49,
        "10-Piece Chicken-McNuggets": 4.29,
        "Filet Fish": 3.79,
        "Cheessy Quarte-Pounder": 5.19,
        "French Fries": 1.89,
        "Soft Drink": 1.00,
        "Apple Pie": 0.99
    },
    "Chipotle House": {
        "Burrito Bowl": 7.99,
        "Steak Quesadilla": 4.99,
        "Crispy Tacos": 3.99,
        "Barbacoa Salad": 8.99,
        "Chips Guac": 3.99,
        "Soft Drinks": 2.29,
        "Chocolate Brownie": 2.25
    }
}


# ChatGPT API setup
openai.api_key = "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"

def recognize_speech(audio):
   audio_file = open(audio,"rb")
   transcript=openai.Audio.transcribe("whisper-1",audio_file)
   print(transcript)

   return transcript["text"]

def chatbot(command):
      response = openai.ChatCompletion.create(
      model="gpt-3.5-turbo",
      messages=[
              {"role": "system", "content": "You are a Restaurants chatbot Who takes order,shows menus and answers users food related querry's presiously"},
              {"role": "user", "content": command},
          ]
              )
      result = ''
      for choice in response.choices:
          result += choice.message.content
      return result

def nlp(txt_summ):
    completion = openai.Completion.create(
    model="text-davinci-003",
    prompt= txt_summ ,
    temperature=0.7,
    max_tokens=64,
    top_p=1.0,
    frequency_penalty=0.0,
    presence_penalty=0.0
    )
    response = completion.choices[0].text
     
    return response
# Get menu for a specific restaurant
def get_menu_items(restaurant): 
  return restaurants[restaurant]

def identify_food_command(text):
    keywords = ['order', 'menu', 'food']
    for keyword in keywords:
        if keyword in text:
            return keyword
    return None

# Main function to handle user inputs and chatbot responses
def main(audio):
    while True:
        try:
            print("What can I help you with?")
            command = recognize_speech(audio)
            print(f"You said: {command}")
            txt_command ="extract the food related command keyword from the sentence :\n\n"+command
            food_command = (" ".join(nlp(txt_command).strip().split()[-1:])).lower()
            print(food_command)

            restaurant_name = ''
            txt_extract = "extract the restaurants name from the sentence :\n\n"+command
            restaurant_name = " ".join(((nlp(txt_extract)).strip()).title().split()[-2:])
            found_rest = False
            if(restaurant_name in restaurants.keys()):
              found_rest = True  

            item_name = ''
            txt_extract = "extract the food name from the given sentence :\n\n"+command
            item_name = " ".join(((nlp(txt_extract)).strip()).title().strip(".,;:").split()[-2:])
            found_item = False
            for restaurant, rest_info in restaurants.items():
                  if item_name in rest_info:
                      found_item = True
                      

            print(found_item , found_rest)   
            if food_command in ['order', 'eat' , 'want' , 'serve' , 'prepare' ]:
              if not found_rest and found_item: 
                temp_val = {}
                for restaurant, rest_info in restaurants.items():
                  if item_name in rest_info:
                    temp_val[restaurant] = rest_info[item_name]
                if temp_val:
                  min_price =  min(temp_val.values())
                  res = [key for key in temp_val if temp_val[key] == min_price]
                  response = f"You have ordered {item_name} from {res[0]} with price of {min_price}"
                  
                                
              elif found_rest and found_item:
                response = f"\nYou ordered {item_name} from {restaurant_name}\nGreat! Thank you for ordering."

              elif found_rest and not found_item :
                menu_items = get_menu_items(restaurant_name)
                response = f"Sure, here's the menu for {restaurant_name}: {menu_items} What would you like to order?"
                max_tries = 3
                for i in range(max_tries):
                      order_audio = input()
                      item = order_audio
                      if item == "nothing":
                          response = "Okay! You don't want anything"
                          break
                      elif item in restaurants[restaurant_name].keys():
                          response = f"\nYou ordered {item} from {restaurant_name.title()}\nGreat! Thank you for ordering."
                          break
                      else:
                          if i == max_tries - 1:
                              response = "Sorry, you didn't provide any valid input. Goodbye!"
                              break
                          else:
                              response = "Sorry, that item is not available at this restaurant. Please try again."
              else :
                  resp = "Respond properly and Try to make the Customer buy some food and for the valid response"
                  response = chatbot(resp)


            elif food_command in ['menu' , 'menus' , 'catalogue' , 'items' , 'something']:
               if found_rest:   
                  menu_items = get_menu_items(restaurant_name)
                  response = f"Here's the menu for {restaurant_name}: {menu_items}"
               else:
                  response = chatbot(command)
            elif identify_food_command(command) == 'food':
              response=chatbot("Respond a person properly who has come to your restaurant asking food")
            else:
               response=chatbot("Response, as if you cannot understand and make the person salivate so that he buys a food . Also Give proper reply for the output\n"+command)
            
            return response
        
        except sr.UnknownValueError:
            print("Sorry, I did not understand what you said.")
        except sr.RequestError:
            print("Sorry, I am unable to process your request.")
        except Exception as e:
            print("An error occurred:", e)



interface = gr.Interface(
    main,
    inputs=gr.Audio(source="microphone", type="filepath", label="Input Audio"),
    outputs= gr.Textbox(label="Foodie Chatbot's response"),
    title="Foodie Chatbot",
    description="Talk to the Foodie Chatbot and get restaurant recommendations and menus!",
)
if __name__ == "__main__":
    interface.launch(inline=False)
    