from fastai.vision.all import *
import gradio as gr
learn = load_learner("export.pkl")
cateogeries = ['Dog',
 'Horse',
 'Elephant',
 'Butterfly',
 'Hen',
 'Cat',
 'Cow',
 'Sheep',
 'Spider',
 'Squirrel' 
 ]

def classify_image(img):
    pred,idx, prob = learn.predict(img)
    return dict(zip(cateogeries, map(float, prob)))

image = gr.inputs.Image(shape=(192,192))
label  = gr.outputs.Label()
examples = ["butterfly.jpg", "cat.jpg", "dog.jpg", "elephant.jpg" ]
intf = gr.Interface(fn = classify_image, inputs = image, outputs = label, examples = examples)
intf.launch(inline = False)

#def greet(name):
   # return "Hello " + name + "!!"

#iface = gr.Interface(fn=greet, inputs="text", outputs="text")
#iface.launch()