from transformers import BertTokenizer, EncoderDecoderModel
import gradio as gr

tokenizerM = BertTokenizer.from_pretrained("mareloraby/BERTShared-PoetryGen-arV01")
bertSharedM = EncoderDecoderModel.from_pretrained("mareloraby/BERTShared-PoetryGen-arV01")
# bertSharedM.cuda()


def generate_response(text, k = 70, p = 0.9, nb = 4):
  prompt = f"{text}"
  encoded_prompt = tokenizerM.encode_plus(prompt, return_tensors = 'pt')#.to(device)
  gneration = bertSharedM.generate(
                            input_ids = encoded_prompt.input_ids, 
                            attention_mask = encoded_prompt.attention_mask, 
                            do_sample = True,
                            top_k= k, 
                            top_p = p,
                            num_beams= nb,
                            max_length =130, 
                            repetition_penalty = 2.0,  
                            no_repeat_ngram_size = 2,
                            early_stopping=True)
                    
  generated_text = tokenizerM.decode(gneration[0], skip_special_tokens=True) 
  bayts = generated_text.split("[BSEP]")
  while("FSEP" not in bayts[-1]):
    bayts = bayts[:-1]
  bayts = bayts[:-1]
  temp_poem = ''
  for b in range(len(bayts)):
      temp_line = bayts[b].split('[FSEP]')
      temp_poem = temp_poem + temp_line[1] + ' - ' + temp_line[0] +'\n'

  return temp_poem

iface = gr.Interface(fn=generate_response,
             title = 'BERTShared - topic based generation',
          
              inputs=[
          gr.inputs.Radio(['حزينه','هجاء','عتاب','غزل','مدح','رومنسيه','دينية'],label='Choose Topic'),
          gr.inputs.Slider(10, 200, step=10,default = 70, label='Top-K'),
          gr.inputs.Slider(0.10, 0.99, step=0.02, default = 0.90, label='Top-P'),
          #gr.inputs.Slider(1, 20, step=1, default = 4, label='Beams'),

          ],
             outputs="text")
             
iface.launch()