from transformers import BertTokenizer, EncoderDecoderModel
import gradio as gr

tokenizerM = BertTokenizer.from_pretrained("mareloraby/BERTShared-meter2poem-arV01")
bertSharedM = EncoderDecoderModel.from_pretrained("mareloraby/BERTShared-meter2poem-arV01")

def generate_response(text, k = 70, p = 0.7, nb = 4):
# meters = set(['الرمل','البسيط','الخفيف','الكامل','السريع','الطويل','المتقارب','الرجز','المجتث','المنسرح','الوافر','المقتضب','الهزج','المديد','المضارع'])
  prompt = f"{text}"
  encoded_prompt = tokenizerM.encode_plus(prompt, return_tensors = 'pt')#.to(device)
  gneration = bertSharedM.generate(
                            input_ids = encoded_prompt.input_ids, 
                            attention_mask = encoded_prompt.attention_mask, 
                            do_sample = True,
                            top_k= k, 
                            top_p = p,
                            num_beams= nb,
                            max_length =130, 
                            repetition_penalty = 2.0,  
                            no_repeat_ngram_size = 2,
                            early_stopping=True)
                    
  generated_text = tokenizerM.decode(gneration[0], skip_special_tokens=True) 
  bayts = generated_text.split("[SOB]")
  while("BSEP" not in bayts[-1]):
    bayts = bayts[:-1]
  # if(len(bayts[-1]) < 2):
  #   bayts = bayts[:-1]
  bayts = bayts[:-1]
  temp_poem = ''
  for b in range(len(bayts)):
      temp_line = bayts[b].split('[BSEP]')
      temp_poem = temp_poem + temp_line[1] + ' - ' + temp_line[0] +'\n'

  return temp_poem
  
  
  
gr.Interface(fn=generate_response,
           title = 'BERTShared - meter based generation',
          #  description ='''
          #  topics : ['حزينه','هجاء','عتاب','غزل','مدح','رومنسيه','دينية','وطنيه']
          #  ''',
            inputs=[
        gr.inputs.Radio(['الرمل','البسيط','الخفيف','الكامل','السريع','الطويل','المتقارب','الرجز','المجتث','المنسرح','الوافر','المقتضب','الهزج','المديد','المضارع'],label='Choose Meter'),
        gr.inputs.Slider(10, 200, step=10,default = 70, label='Top-K'),
        gr.inputs.Slider(0.10, 0.99, step=0.02, default = 0.70, label='Top-P'),
       # gr.inputs.Slider(1, 20, step=1, default = 4, label='Beams'),
        ],
           outputs="text").launch()
           