import os
import gradio as gr
from PIL import Image
from huggingface_hub import hf_hub_url, cached_download


os.system("git clone https://github.com/AK391/stylegan2-ada-pytorch")


os.chdir("stylegan2-ada-pytorch")

os.mkdir("outputs")
os.mkdir("outputs/images")

config_file_url = hf_hub_url("AUBMC-AIM/OCTaGAN", filename="OCTaGAN.pkl")
cached_file = cached_download(config_file_url)

def inference(truncation,seeds):
  os.system("python generate.py --outdir=./outputs/images/ --trunc="+str(truncation)+" --seeds="+str(int(seeds))+" --network="+cached_file)
  seeds = int(seeds)
  image = Image.open(f"./outputs/images/seed{seeds:04d}.png")
  return image

title = "OCTaGAN"
description = "Gradio demo for OCTaGAN. OCTaGAN is a GAN trained on wide-field corneal Optical Coherence Tomography (OCT) scans to generate cornea scans with a variety of pathologies (e.g.keratoconus disease) and surgical procedures (e.g. Implantable Collamer Lens surgery, intrastromal corneal ring segment surgery, and Laser vision correction). OCTaGAN can be used for educational purposes as well as for generating training examples for ML algorithms."

article = "<p style='text-align: center'><a href='' target='_blank'>OCTaGAN</a><center><a href='https://colab.research.google.com/drive/1vfbvMMkEBIwiuSbuC5pP-hsQr1nBmJXa?usp=sharing' target='_blank'><img src='https://colab.research.google.com/assets/colab-badge.svg' alt='Open In Colab'/></a></center></p><center><img src='https://visitor-badge.glitch.me/badge?page_id=AUBMC-AIM_octogan' alt='visitor badge'></center>"


gr.Interface(inference,[gr.inputs.Slider(label="truncation",minimum=0, maximum=5, step=0.1, default=0.8),gr.inputs.Slider(label="Seed",minimum=0, maximum=1000, step=1, default=0)],"pil",title=title,description=description,article=article, examples=[
    [0.8,0]
    ]).launch(enable_queue=True,cache_examples=True)