_base_ = [                                    # 此配置文件将继承所有 `_base_` 中的配置
    '../configs/_base_/schedules/custom_schedule.py',  # 训练策略配置
    '../configs/_base_/default_runtime.py'            # 默认运行设置
]

default_hooks = dict(
    # print log every 50 iterations.
    logger=dict(type='LoggerHook', interval=25),
    # save checkpoint per 8 epochs.
    checkpoint=dict(save_best='auto', interval=16)
)

visualizer = dict(
    vis_backends=[dict(type='LocalVisBackend'),
                  dict(type='WandbVisBackend')])

dataset_type = 'CustomDataset'

# config of pipline
train_pipeline = [
    dict(type='LoadImageFromFile', imdecode_backend='pillow', flag='unchanged'),     # 读取图像
    dict(type='RandomResizedCrop', scale=224),     # 随机放缩裁剪
    dict(type='RandomFlip', prob=0.5, direction='horizontal'),   # 随机水平翻转
    dict(type='PackInputs'),         # 准备图像以及标签
]

test_pipeline = [
    dict(type='LoadImageFromFile', imdecode_backend='pillow', flag='unchanged'),     # 读取图像
    dict(type='ResizeEdge', scale=256, edge='short'),  # 缩放短边尺寸至 256px
    dict(type='CenterCrop', crop_size=224),     # 中心裁剪
    dict(type='PackInputs'),                 # 准备图像以及标签
]

# config of dataloader
train_dataloader = dict(
    batch_size=32,                     # 每张 GPU 的 batchsize
    num_workers=5,                     # 每个 GPU 的线程数
    dataset=dict(                      # 训练数据集
        type=dataset_type,
        data_root='../2_preprocess_data_3000',
        with_label=True,
        ann_file='',
        data_prefix='train',
        pipeline=train_pipeline),
    sampler=dict(type='DefaultSampler', shuffle=True),   # 默认采样器
    persistent_workers=True,                             # 是否保持进程，可以缩短每个 epoch 的准备时间
)

# 构造验证集 dataloader
val_dataloader = dict(
    batch_size=32,
    num_workers=5,
    dataset=dict(
        type=dataset_type,
        data_root='../2_preprocess_data_3000',
        with_label=True,
        ann_file='',
        data_prefix='val',
        pipeline=test_pipeline),
    sampler=dict(type='DefaultSampler', shuffle=False),
    persistent_workers=True,
)

# set evaluator of validation dataset. Here uses top1 and top3 accuracy
val_evaluator = dict(type='Accuracy', topk=(1, 3))

test_dataloader = val_dataloader
test_evaluator = val_evaluator

model = dict(
    type='ImageClassifier',     # 主模型类型（对于图像分类任务，使用 `ImageClassifier`）
    backbone=dict(
        type='HRNet',           # 主干网络类型
        arch='w32',             # 主干网络架构
        extra=dict(
            stage1=dict(
                num_modules=1,
                num_branches=1,
                block='BOTTLENECK',
                num_blocks=(4, ),
                num_channels=(64, )),
            stage2=dict(
                num_modules=1,
                num_branches=2,
                block='BASIC',
                num_blocks=(4, 4),
                num_channels=(32, 64)),
            stage3=dict(
                num_modules=4,
                num_branches=3,
                block='BASIC',
                num_blocks=(4, 4, 4),
                num_channels=(32, 64, 128)),
            stage4=dict(
                num_modules=3,
                num_branches=4,
                block='BASIC',
                num_blocks=(4, 4, 4, 4),
                num_channels=(32, 64, 128, 256))),
    ),
    neck=dict(type='GlobalAveragePooling'),    # 颈网络类型
    head=dict(
        type='LinearClsHead',         # 分类颈网络类型
        # 除了 `type` 之外的所有字段都来自 `LinearClsHead` 类的 __init__ 方法
        # 可查阅 https://mmpretrain.readthedocs.io/zh_CN/latest/api/generated/mmpretrain.models.heads.LinearClsHead.html
        num_classes=7,                # 分类类别数
        in_channels=256,
        loss=dict(type='CrossEntropyLoss', loss_weight=1.0),  # 损失函数配置信息
        topk=(1, 3),                 # 评估指标，Top-k 准确率
    ))

optim_wrapper = dict(
    accumulative_counts=8
)
