optim_wrapper = dict(
    # 使用 SGD 优化器来优化参数
    type='OptimWrapper',
    optimizer=dict(
        type='Adam',
        lr=0.0001,
        betas=(0.9, 0.999),
        eps=1e-08,
        weight_decay=0,
        amsgrad=False),
    accumulative_counts=4
)

# 学习率参数的调整策略
param_scheduler = [
    # 在前10轮迭代中，逐迭代次数，线性预热
    dict(type='LinearLR',
         start_factor=0.00001,
         by_epoch=True,
         end=10,
         convert_to_iter_based=True,  # 逐迭代次数更新学习率.
         ),
    # 在 10 轮次后，通过余弦退火衰减
    dict(type='MultiStepLR',
         by_epoch=True,  # 按轮次更新学习率
         milestones=[30, 120, 200, 270, 330, 390, 450, 510, 580, 660, 750, 840, 930],
         gamma=0.9)
]

# 'by_epoch=True' 默认使用 `EpochBaseLoop`,  'by_epoch=False' 默认使用 `IterBaseLoop`
train_cfg = dict(by_epoch=True, max_epochs=1024, val_interval=16)
# 使用默认的验证循环控制器
val_cfg = dict()
# 使用默认的测试循环控制器
test_cfg = dict()

# 通过默认策略自动缩放学习率，此策略适用于总批次大小 256
# 如果你使用不同的总批量大小，比如 512 并启用自动学习率缩放
# 我们将学习率扩大到 2 倍
# auto_scale_lr = dict(base_batch_size=256)
