_base_ = [                                    # 此配置文件将继承所有 `_base_` 中的配置
    '../configs/_base_/schedules/custom_schedule.py',  # 训练策略配置
    '../configs/_base_/default_runtime.py'            # 默认运行设置
]

default_hooks = dict(
    # print log every 50 iterations.
    logger=dict(type='LoggerHook', interval=10),
    # save checkpoint per 8 epochs.
    checkpoint=dict(save_best='auto', interval=16)
)

visualizer = dict(
    vis_backends=[dict(type='LocalVisBackend'),
                  dict(type='WandbVisBackend')])

dataset_type = 'CustomDataset'

# config of pipline
train_pipeline = [
    dict(type='LoadImageFromFile', imdecode_backend='pillow', color_type='unchanged'),     # 读取图像
    dict(type='RandomResizedCrop', scale=224),     # 随机放缩裁剪
    dict(type='RandomFlip', prob=0.5, direction='horizontal'),   # 随机水平翻转
    dict(type='PackInputs'),         # 准备图像以及标签
]

test_pipeline = [
    dict(type='LoadImageFromFile', imdecode_backend='pillow', color_type='unchanged'),     # 读取图像
    dict(type='ResizeEdge', scale=256, edge='short'),  # 缩放短边尺寸至 256px
    dict(type='CenterCrop', crop_size=224),     # 中心裁剪
    dict(type='PackInputs'),                 # 准备图像以及标签
]

# config of dataloader
train_dataloader = dict(
    batch_size=32,                     # 每张 GPU 的 batchsize
    num_workers=5,                     # 每个 GPU 的线程数
    dataset=dict(                      # 训练数据集
        type=dataset_type,
        data_root='../2_preprocess_data_3000',
        with_label=True,
        ann_file='',
        data_prefix='train',
        pipeline=train_pipeline),
    sampler=dict(type='DefaultSampler', shuffle=True),   # 默认采样器
    persistent_workers=True,                             # 是否保持进程，可以缩短每个 epoch 的准备时间
)

# 构造验证集 dataloader
val_dataloader = dict(
    batch_size=32,
    num_workers=5,
    dataset=dict(
        type=dataset_type,
        data_root='../2_preprocess_data_3000',
        with_label=True,
        ann_file='',
        data_prefix='val',
        pipeline=test_pipeline),
    sampler=dict(type='DefaultSampler', shuffle=False),
    persistent_workers=True,
)

# set evaluator of validation dataset. Here uses top1 and top3 accuracy
val_evaluator = dict(type='Accuracy', topk=(1, 3))

test_dataloader = val_dataloader
test_evaluator = val_evaluator

model = dict(
    type='ImageClassifier',     # 主模型类型（对于图像分类任务，使用 `ImageClassifier`）
    backbone=dict(
        type='ResNeXt',           # 主干网络类型
        depth=101,
        in_channels=4,            # 输入通道数
    ),
    neck=dict(type='GlobalAveragePooling'),    # 颈网络类型
    head=dict(
        type='LinearClsHead',         # 分类颈网络类型
        # 除了 `type` 之外的所有字段都来自 `LinearClsHead` 类的 __init__ 方法
        # 可查阅 https://mmpretrain.readthedocs.io/zh_CN/latest/api/generated/mmpretrain.models.heads.LinearClsHead.html
        num_classes=7,                # 分类类别数
        in_channels=2048,
        loss=dict(type='CrossEntropyLoss', loss_weight=1.0),  # 损失函数配置信息
        topk=(1, 3),                 # 评估指标，Top-k 准确率
    ))

optim_wrapper = dict(
    accumulative_counts=8
)

param_scheduler = [
    # 在前10轮迭代中，逐迭代次数，线性预热
    dict(type='LinearLR',
         start_factor=0.00001,
         by_epoch=True,
         end=10,
         convert_to_iter_based=True,  # 逐迭代次数更新学习率.
         ),
    # 在 10 轮次后，通过余弦退火衰减
    dict(type='MultiStepLR',
         by_epoch=True,  # 按轮次更新学习率
         milestones=[30, 210, 390, 570, 750, 930, 1110, 1290, 1470, 1650, 1830],
         gamma=0.9)
]

train_cfg = dict(by_epoch=True, max_epochs=2048, val_interval=16)