from osgeo import gdal
import os
from PIL import Image
import numpy as np

path = '/home/super/datasets-nas/hirise_oxia_planum_test_tiles_thruth/'

for i, file_name in enumerate(os.listdir(path)[40:90]):
    file_path = os.path.join(path, file_name)
    x = gdal.Open(file_path)
    x_array = x.ReadAsArray()
    # print(x_array.shape)
    pil_img = Image.fromarray(np.uint8(x_array), 'L')
    pil_img.save(f'demo_imgs/{i}.png')
