from transformers import AutoTokenizer, TFAutoModel
import tensorflow as tf
#from keras.preprocessing.sequence import pad_sequences
from tensorflow.keras.preprocessing.sequence import pad_sequences
import pickle
import numpy as np
from keras.models import load_model
import streamlit as st
import io
import PyPDF2
import re
from PIL import Image

image = Image.open('header-image.png')
st.image(image)

   
def preprocess(text):
    # Define a regular expression pattern for URLs, non-alphabetic characters, and user names
    pattern = re.compile(r'https?://\S+|[^0-9A-Za-z\' t]|@\w+')
    # Use the regular expression to find all URLs, non-alphabetic characters, and user names in the text
    matches = pattern.findall(text)
    #Replace the URLs, non-alphabetic characters, and user names with an empty string
    for match in matches:
        text = text.replace(match, ' ')
    return text



def predict(new_data):
    #Load the trained model
    # Create a LabelEncoder object
    with open("labelencoder1.pkl", 'rb') as f:
        le = pickle.load(f)
    model= tf.keras.models.load_model("biobert-rnn1.h5")
    tokenizer = AutoTokenizer.from_pretrained("dmis-lab/biobert-base-cased-v1.1")
    biobert_model = TFAutoModel.from_pretrained("dmis-lab/biobert-base-cased-v1.1", from_pt=True)
    X_tokens = [tokenizer.encode(text, add_special_tokens=True) for text in new_data.split()]
    X_padded = pad_sequences(X_tokens, maxlen=22, dtype='long', truncating='post', padding='post')
    X_tensor = tf.convert_to_tensor(X_padded)
    X_embeddings = biobert_model(X_tensor)[0]
    pred=model.predict(X_embeddings)
    predicted_labels = list(le.inverse_transform(np.argmax(pred, axis=1)))
    text=new_data.split()
    prev_label=" "
    data=[]
    labels=[]
    for i,(word,label) in enumerate(zip(text,predicted_labels)):
        if label!="Other":
            label=label.split('-')[1]
        if prev_label==label:
                data[-1]=data[-1]+" "+word
        else:
            data.append(word)
            labels.append(label)
        prev_label=label
    return(data,labels)

def highlight(sentence):
    highlighted_text = ""
    entity_colors = {"Symptom":"#87cefa","Medical Condition":"#ffb6c1"}
    words, labels = predict(sentence)
    for words, label in zip(words, labels):
        if label!="Other" and words!="a":
            if label in ["Medical Condition","Symptom"]:
                    word_color = entity_colors.get(label, "yellow")
                    label_color = entity_colors.get(label + '-label', "<b>black</b>")
                    highlighted_text += f'<mark style="background-color: {word_color}; color: {label_color}; padding: 0 0.25rem; border-radius: 0.25rem; border: 2px solid {word_color}; border-bottom-width: 1px">{words}<sup style="background-color: white; color: black; border: 1px solid black; border-radius: 2px; padding: 0 0.15rem; font-size: 70%; margin-left: 0.15rem; font-weight: bold;">{label}</sup></mark> '
            else:
                highlighted_text += f'{words} '
        else:
            highlighted_text += f'{words} '
    st.markdown(highlighted_text, unsafe_allow_html=True)

st.subheader('Named Entity Recognizer for Oral Medicine and Radiology')
sentence = st.text_area('Enter some text:')

st.write("OR") 

selected_options = st.selectbox(
'Choose a text from dropdown: ',
(" ",
    'Anemia and gingival bleeding are connected in that anemia can be a contributing cause to the occurrence of gingival bleeding . Anemia is a condition characterized by a shortage in the number or quality of red blood cells, which can lead to a reduced ability of the blood to carry oxygen throughout the body.', 
    'Hemophilia is a genetic illness that mainly affects the blood ability to clot properly. Individuals with significant hemophilia are at an elevated possibility of experiencing unforeseen bleeding episodes, which can occur in various parts of the body, including the mouth. Gingival bleeding can be a sign of hemophilia and can present as  gum bleeding or mouth sores.', 
    "Von Willebrand disease VWD  is a genetic condition that impairs the blood's ability to  clot properly. One of the symptoms of VWD is spontaneous gingival bleeding , which can occur without any apparent cause or trauma"))  # set default to None


# Define the colors for each label

if st.button('Analyze'):
    if sentence:
        highlight(sentence)
    elif selected_options:
        highlight(selected_options)
    else:
        st.write('Please enter a sentence or select an option from the dropdown or upload a file.')
